<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class PromocionlocalC extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('promociones/cosmetologo/promocionlocalC_model');
		$this->load->library(array('session','form_validation'));
	}

	//Acá se muestra la pantalla principal de este módulo (lista de promociones)
	public function index()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias']=$this->promocionlocalC_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('zona','Zona_IdZona = IdZona','inner');
		$this->db->where('TipoPromocion_IdTipoPromocion','2');
		$this->db->where('Estatus','ACTIVA');
		$this->db->where('Franquicias_IdFranquicias',$i);
			$data['consulta']=$this->db->get('promociones')->result();
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('promociones/cosmetologo/listapromocionlocalC_view',$data);
		$this->load->view('layout/footer');
	}
}
	
	//Esta función muestra en un formulario los datos de una promoción que ha sido guardada anteriormente para ver su información y poder realizarle cambios
	public function editar()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->promocionlocalC_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdPromociones = $fila->IdPromociones;
				$tipopromocion_IdTipoPromocion=$fila->tipopromocion_IdTipoPromocion;
				$NombrePromocion=$fila->NombrePromocion;
				$categoria_IdCategoria = $fila->categoria_IdCategoria;
				$Precio=$fila->Precio;
				$DescripcionPromocion=$fila->DescripcionPromocion;
				$FechaInicioPromocion = $fila->FechaInicioPromocion;
				$FechaTerminoPromocion=$fila->FechaTerminoPromocion;
				$zona_IdZona=$fila->zona_IdZona;
			}
			$data = array(
				'IdPromociones' => $IdPromociones,
				'tipopromocion_IdTipoPromocion' => $tipopromocion_IdTipoPromocion,
				'NombrePromocion' => $NombrePromocion,
				'categoria_IdCategoria' => $categoria_IdCategoria,
				'Precio' => $Precio,
				'DescripcionPromocion' => $DescripcionPromocion,
				'FechaInicioPromocion' => $FechaInicioPromocion,
				'FechaTerminoPromocion' => $FechaTerminoPromocion,
				'zona_IdZona' => $zona_IdZona);
			}else{
				$data ='';
				return FALSE;
		}
		$data['ReCategoria']=$this->promocionlocalC_model->BuscarCategoria();
		$data['ReZona']=$this->promocionlocalC_model->BuscarZona();
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('promociones/cosmetologo/editarpromocionlocalC_view', $data);
		$this->load->view('layout/footer');
		}
	}

	//esta función manda los datos que se desean modificar al modelo para que puedan ser guardados en la bd
	public function editarenlace () 
	{
		$IdPromociones= $this -> uri->segment(5);
		$data=array(
			'IdPromociones' => $this -> input ->post('IdPromociones', true),
			'TipoPromocion_IdTipoPromocion' => $this -> input ->post('TipoPromocion_IdTipoPromocion', true),
			'NombrePromocion' => $this -> input ->post('NombrePromocion', true),
			'Categoria_IdCategoria' => $this -> input ->post('Categoria_IdCategoria', true),
			'Precio' => $this -> input ->post('Precio', true),
			'DescripcionPromocion' => $this -> input ->post('DescripcionPromocion', true),
			'FechaInicioPromocion' => $this -> input ->post('FechaInicioPromocion', true),
			'FechaTerminoPromocion' => $this -> input ->post('FechaTerminoPromocion', true),
			'Zona_IdZona' => $this -> input ->post('Zona_IdZona', true)		
			);
		$this->promocioninstitucionalA_model->editarenlace($IdPromociones, $data);
		redirect('promociones/cosmetologo/promocionlocalC');
	}

	//Esta función permite buscar una promoción por medio de su nombre.
	public function buscar () 
	{	
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {	
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->promocionlocalC_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('promociones/cosmetologo/buscarpromocionlocalC_view', $data);
		$this->load->view('layout/footer');
		}
	}
}