<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class PromocionesF extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('promociones/franquiciatario/PromocionesF_model');
		$this->load->library(array('session','form_validation'));
		$this->load->helper(array('url'));
		

	}

	//Acá se muestra la pantalla principal de este modulo (lista de promociones)
	public function index() { 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'||  
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else { 
    	$data['Franquicias']=$this->PromocionesF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('promociones/franquiciatario/listapromocionesF_view',$data); 
		$this->load->view('layout/footer');
		} 
	}

	public function agregarPromocion(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias']=$this->PromocionesF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$data['ReCategoria']=$this->PromocionesF_model->BuscarCategoria();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('promociones/franquiciatario/agregarpromocionF_view',$data);
		$this->load->view('layout/footer');
		}
	}
	public function promociones()
	{
		$this->PromocionesF_model->Promociones(); 
	}
	public function guardar()
	{
		$data['Franquicias']=$this->PromocionesF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$data['zona']=$this->PromocionesF_model->BuscarZona();
		foreach ($data['zona'] as $z => $zona) 
		if($_POST['tipo']==2)
		{
			$promo='PL';
		}else{
			$promo='PE';
		}
		if($_POST['sesiones']!=1)
		{
			$sesiones='SESIONES';
		}else{
			$sesiones='SESIÓN';
		}
		$campos = array(
			'FolioPromocion' => 'FMAS'.$i.$promo,
			'NombrePromocion'=> strtoupper($promo.'-'.$_POST['nombre'].' '.$_POST['sesiones'].' '.$sesiones),
			'Precio'=>$_POST['precio'],
			'SesionesPromocion'=>$_POST['sesiones'],
			'DuracionPromocion'=>$_POST['duracion'],
			'DescripcionPromocion' => strtoupper($_POST['descripcion']),
			'FechaInicioPromocion' => date("y-m-d", strtotime($_POST['fechai'])),
			'FechaTerminoPromocion' => date("y-m-d", strtotime($_POST['fechaf'])),
			'Estatus' => 'ACTIVA',
			'tipopromocion_IdTipoPromocion' => $_POST['tipo'],
			'categoria_IdCategoria' => $_POST['categoria'],
			'ClasificacionPromocion' => $_POST['clasificacion'],
			'ClasePromocion' => 'SERVICIO',
			'zona_IdZona' => $z,
			'franquicias_IdFranquicias'=> $i

						);
		$this->PromocionesF_model->GuardarPromocion($campos); 
	}
	public function ver()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id=$this->uri->segment(5);
		$datos=$this->PromocionesF_model->VerPromocion($id);
		if($datos!=FALSE)
		{
			foreach ($datos->result() as $fila) 
			{
				$data = array(
					'Sesiones' => $fila->SesionesPromocion,
					'IdPromociones' => $fila->IdPromociones,
					'Tipopromocion' => $fila->TipoPromocion,
					'NombrePromocion' => $fila->NombrePromocion,
					'Categoria' => $fila->NombreCategoria,
					'Clasificacion'=>$fila->ClasificacionPromocion,
					'ClasePromocion' => $fila->ClasePromocion,
					'Sesiones' => $fila->SesionesPromocion,
					'Precio' => $fila->Precio,
					'Estatus' => $fila->Estatus,
					'Descripcion' => $fila->DescripcionPromocion,
					'FechaInicio' => date("d-m-Y", strtotime($fila->FechaInicioPromocion)),
					'FechaTermino' => date("d-m-Y", strtotime($fila->FechaTerminoPromocion)),
					'DuracionPromocion' => $fila->DuracionPromocion
								 );
			}
		}		
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('promociones/franquiciatario/verpromocionF_view',$data);
		$this->load->view('layout/footer');
		}
	}
	public function editar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id=$this->uri->segment(5);
		$datos=$this->PromocionesF_model->VerPromocion($id);
		if($datos!=FALSE)
		{
			foreach ($datos->result() as $fila) 
			{
				$data = array(
					'IdPromociones' => $fila->IdPromociones,
					'Tipopromocion' => $fila->tipopromocion_IdTipoPromocion,
					'NombrePromocion' => $fila->NombrePromocion,
					'Categoria' => $fila->categoria_IdCategoria,
					'Clasificacion'=>$fila->ClasificacionPromocion,
					'ClasePromocion' => $fila->ClasePromocion,
					'Precio' => $fila->Precio,
					'Sesiones'=>$fila->SesionesPromocion,
					'Estatus' => $fila->Estatus,
					'Descripcion' => $fila->DescripcionPromocion,
					'FechaInicio' => date("d-m-Y", strtotime($fila->FechaInicioPromocion)),
					'FechaTermino' => date("d-m-Y", strtotime($fila->FechaTerminoPromocion)),
					'DuracionPromocion' => $fila->DuracionPromocion
				);
			}
		}		
		$data['ReCategoria']=$this->PromocionesF_model->BuscarCategoria();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('promociones/franquiciatario/editarpromocionF_view',$data);
		$this->load->view('layout/footer');
	  }
	}
	public function guardarEdicion() {
		$id=$_POST['id'];
		$campos = array(
			'Precio'=>$_POST['precio'],
			'DescripcionPromocion' => strtoupper($_POST['descripcion']),
			'FechaTerminoPromocion' => date("y-m-d", strtotime($_POST['fechaf'])),
			'Estatus' => $_POST['status'],
			'tipopromocion_IdTipoPromocion' => $_POST['tipo'],
			'categoria_IdCategoria' => $_POST['categoria'],
			'SesionesPromocion'=>$_POST['sesiones'],
			'DuracionPromocion' => $_POST['tiempo'],
						);
		$this->PromocionesF_model->GuardarEdicion($campos, $id);
	}
	public function eliminar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id=$this->uri->segment(5);
		$this->PromocionesF_model->Eliminar($id);
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('promociones/franquiciatario/verpromocionF_view',$data);
		$this->load->view('layout/footer');
		}
	}
	public function reportePromociones()
	{
			if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('reportes/Franquiciatario/reportePromociones');
		$this->load->view('layout/footer');
			
		}
	}

	public function buscarPromociones()
	{
		$fechaInicio=date("Y-m-d", strtotime($_POST['finicio']));
		$fechaFin=date("Y-m-d", strtotime($_POST['ffin']));
		$status=$_POST['status'];
		$tipo=$_POST['tipo'];

		$this->PromocionesF_model->BuscarPromociones($fechaInicio, $fechaFin, $status, $tipo);		
	}

	public function activarPromocion()
	{
		$id=$_POST['id'];
		$fechaTermino=$_POST['fecha'];
		$tiempo=$_POST['tiempo'];
		$this->PromocionesF_model->ActivarPromocion($id,$fechaTermino,$tiempo);
	}
}

