<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará aque el modulo realize sus funciones(Administrador general)
class RFranquicias extends CI_Controller
{
  //Construtor que manda a traer las librerias de sesión y validación
  //Manda a llamar el modelo
  public function __construct()
  {
    parent::__construct();
    $this->load->model('reportes/Administrador/RFranquicias_model');
    $this->load->library(array('session','form_validation'));
    $this->load->library('mydompdf');
  }
  
  //Manda a traer la vista principal FranquiciasR_view
  public function index()
  {
    if($this->session->userdata('Rol_IdRol')==FALSE || 
      $this->session->userdata('Rol_IdRol') == '2'|| 
      $this->session->userdata('Rol_IdRol') == '3')
    {
      redirect(base_url().'acceso/acceso');
    } else {
    $this->load->model('reportes/Administrador/RFranquicias_model');
    $data["franquicias"] = $this->RFranquicias_model->fetch_data();
    $this->db->select('*');
    $this->db->join('zona','Zona_IdZona = IdZona','inner');
    $this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
    $data['consulta']=$this->db->get('franquicias')->result();
    $this->load->view('layout/header');
    $this->load->view('layout/menuAdmin');
    $data['ReZona']=$this->RFranquicias_model->Buscarzona();
    $data['ReModel']=$this->RFranquicias_model-> BuscarModelo();
    $this->load->view('reportes/Administrador/FranquiciasR_view',$data);
    $this->load->view('layout/footer');
  }
}

  public function actiongeneral()
    {
      $this->db->select('*');
      $this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
      $this->db->join('zona','Zona_IdZona= IdZona','inner');
      $data=$this->db->get('franquicias');
      $this->load->model("RFranquicias_model");
      $this->load->library("GenerarReporteExcel/excel");
      $object = new PHPExcel();
      $object->setActiveSheetIndex(0);     
      $object->getActiveSheet()->setTitle('Reporte General de Franquicias');
      $object->getActiveSheet()->getStyle('3')->applyFromArray(
        array(
      'font' => array(
      'bold' => TRUE
    )
    )
    ); 
       
      $table_columns = array ("FRANQUICIA","DOMICILIO","ESTADO","MODELO", "MUNICIPIO", "TELÉFONO","CELULAR","CORREO PERSONAL","CORREO CORPORATIVO","NOMBRE PROPIETARIO","ZONA");

      $column = 0;
      $field = 3;
      
      foreach($table_columns as $field)
      {
       $object->getActiveSheet()->setCellValueByColumnAndRow($column,3, $field);
       $column++;
      }

      $franquicias = $this->RFranquicias_model->fetch_data();

      $excel_row = 4;

      foreach($franquicias as $row)
      {
    //Funcion para dar el tamaño a cada columna del formato excel.
        $object->getActiveSheet()->getColumnDimension('A')->setWidth(30);
        $object->getActiveSheet()->getColumnDimension('B')->setWidth(40);
        $object->getActiveSheet()->getColumnDimension('C')->setWidth(20);
        $object->getActiveSheet()->getColumnDimension('D')->setWidth(25);
        $object->getActiveSheet()->getColumnDimension('E')->setWidth(30);
        $object->getActiveSheet()->getColumnDimension('F')->setWidth(15);
        $object->getActiveSheet()->getColumnDimension('G')->setWidth(15);
        $object->getActiveSheet()->getColumnDimension('H')->setWidth(35);
        $object->getActiveSheet()->getColumnDimension('I')->setWidth(35);
        $object->getActiveSheet()->getColumnDimension('J')->setWidth(35);
        $object->getActiveSheet()->getColumnDimension('K')->setWidth(12);
    //Funcion para mostrar los datos de cada columna que tendran el documento en excel.
       $object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->NombreFranquicia);
       $object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->DomicilioFranquicia); 
       $object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row->Estado);
       $object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->NombreModelo);
       $object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $row->Municipio);
       $object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row->TelefonoFranquicia);
       $object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $row->CelularPropietario);
       $object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $row->CorreoPersonal);
       $object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $row->CorreoCorp);
       $object->getActiveSheet()->setCellValueByColumnAndRow(9, $excel_row, $row->NombrePropietario);
       $object->getActiveSheet()->setCellValueByColumnAndRow(10, $excel_row, $row->NombreZona);

       $excel_row++;  
    }
     //Funcion que genera el excel para su descarga.
      $object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel5');
      header('Content-Type: application/vnd.ms-excel');
      header('Content-Disposition: attachment;filename="Reporte General de Franquicias.xls"');
       // Forzamos a la descarga
      $object_writer->save('php://output');
      
  }

  //Función que busca a la franquicia de acuerdo la zona con la que se logueo el usuario
  public function buscarporzona()
  {
    if($this->session->userdata('Rol_IdRol')==FALSE || 
      $this->session->userdata('Rol_IdRol') == '2'|| 
      $this->session->userdata('Rol_IdRol') == '3')
    {
      redirect(base_url().'acceso/acceso');
    } else {
    $this->db->select('*');
    $this->db->join('zona','Zona_IdZona= IdZona','inner');
    $this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
    $data = array();
    $query = $this->input->get('query', TRUE);
    if ($query) {
      $result = $this->RFranquicias_model->buscarporzona(trim($query));
      
      if ($result != FALSE){
        $data = array(
          'result' => $result,
          
    );
      }else  {
        $data = array('result' => '');
      } 
    }else{
      $data = array('result' => '');
    }
    $this->load->view('layout/header');
    $this->load->view('layout/menuAdmin');
    $data['ReZona']=$this->RFranquicias_model->Buscarzona();
    $html=($this->load->view('reportes/Administrador/ReportePorZona', $data, true));
      $this->mydompdf->load_html($html);  
      $this->mydompdf->set_paper('a4', 'landscape'); 
      $this->mydompdf->render();
      $this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      $this->mydompdf->stream("Reporte Por Zona.pdf", array("Attachment" => false));
    $this->load->view('layout/footer');

    }
  }

  public function buscarpormodelo()
  {
    if($this->session->userdata('Rol_IdRol')==FALSE || 
      $this->session->userdata('Rol_IdRol') == '2'|| 
      $this->session->userdata('Rol_IdRol') == '3')
    {
      redirect(base_url().'acceso/acceso');
    } else {
    $this->db->select('*');
    $this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
    $this->db->join('zona','Zona_IdZona= IdZona','inner');
    $data = array();
    $query = $this->input->get('query', TRUE);
    if ($query) {
      $result = $this->RFranquicias_model->buscarpormodelo(trim($query));
      
      if ($result != FALSE){
        $data = array(
          'result' => $result,       
    );
      }else  {
        $data = array('result' => '');
      } 
    }else{
      $data = array('result' => '');
    }
    $this->load->view('layout/header');
    $this->load->view('layout/menuAdmin');
    $data['ReModel']=$this->RFranquicias_model->BuscarModelo();
   $html=($this->load->view('reportes/Administrador/ReportePorModelo', $data, true));
      $this->mydompdf->load_html($html);  
      $this->mydompdf->set_paper('a4', 'landscape'); 
      $this->mydompdf->render();
      $this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      $this->mydompdf->stream("Reporte Por Modelo.pdf", array("Attachment" => false));
    $this->load->view('layout/footer');
    }
  }

  public function buscar()
  {
    if($this->session->userdata('Rol_IdRol')==FALSE || 
      $this->session->userdata('Rol_IdRol') == '2'|| 
      $this->session->userdata('Rol_IdRol') == '3')
    {
      redirect(base_url().'acceso/acceso');
    } else {
      $data = array('result' => '');
    }
    $this->load->view('layout/header');
    $this->load->view('layout/menuAdmin');
    $this->load->view('reportes/Administrador/BuscarFranquicia_view',$data);
    $data['ReZona']=$this->RFranquicias_model->Buscarzona();
    $data['ReModel']=$this->RFranquicias_model->BuscarModelo();
    $this->load->view('layout/footer');
  }
}