<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará aque el modulo realize sus funciones(Administrador general)
class RProductos extends CI_Controller
{
	//Construtor que manda a traer las librerias de sesión y validación
	//Manda a llamar el modelo
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Administrador/Productos_Model');
		$this->load->library(array('session','form_validation')); 
		$this->load->library('mydompdf');
	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal FranquiciasR_view
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
        $this->load->model('reportes/Administrador/Productos_Model');
		$data["productosgenerales"] = $this->Productos_Model->fetch_data();
		
    		$this->db->select('*');
            
			$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
			$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
			
		$data['consulta']=$this->db->get('productosgenerales')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->Productos_Model->BuscarFranq();
		$data['ReTipo']=$this->Productos_Model->BuscarTipo();
		$data['ReCat']=$this->Productos_Model-> BuscarCategoria();
		$this->load->view('reportes/Administrador/Productos_view',$data);
		$this->load->view('layout/footer');
    	}
	}

	public function buscarporfranquicia()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('rol','Rol_IdRol = IdRol','inner');
		$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Productos_Model->buscarporfranquicia(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,			
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->Productos_Model->BuscarFranq();
		$html=($this->load->view('reportes/Administrador/ReportePPorFranquicia', $data, true));
      	$this->mydompdf->load_html($html);  
      	$this->mydompdf->set_paper('a4', 'landscape'); 
      	$this->mydompdf->render();
      	$this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      	$this->mydompdf->stream("Reporte Por Franquicia.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
 		}
	}

	public function buscarportipo()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$this->db->select('*');
	    
			$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
			$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Productos_Model->buscarportipo(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,			
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReTipo']=$this->Productos_Model->BuscarTipo();
		$html=($this->load->view('reportes/Administrador/ReportePPorTipo', $data, true));
      	$this->mydompdf->load_html($html);  
      	$this->mydompdf->set_paper('a4', 'landscape'); 
      	$this->mydompdf->render();
      	$this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      	$this->mydompdf->stream("Reporte Por Tipo.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
		}
 	}

	public function buscarporcategoria()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
		$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Productos_Model->buscarporcategoria(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,			
				);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReCat']=$this->Productos_Model->BuscarCategoria();
		$html=($this->load->view('reportes/Administrador/ReporteCTPorCategoria', $data, true));
      	$this->mydompdf->load_html($html);  
     	$this->mydompdf->set_paper('a4', 'landscape'); 
      	$this->mydompdf->render();
      	$this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      	$this->mydompdf->stream("Reporte Por Categoria.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
		}
  	}
	public function buscar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('reportes/Administrador/BuscarProducto_view',$data);
		$data['ReTipo']=$this->Productos_Model->BuscarTipo();
		$data['ReCat']=$this->Productos_Model->BuscarCategoria();
		$data['ReFranq']=$this->Productos_Model->BuscarFranq();
		$this->load->view('layout/footer');
	}

    public function actiongeneral()
	{
		$this->db->select('*');
		 	//$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
		$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$query=$this->db->get('productosgenerales');
		$this->load->model("Productos_Model");
		$this->load->library("GenerarReporteExcel/excel");
		  	$object = new PHPExcel();
		  	$object->setActiveSheetIndex(0);
		  	$object->getActiveSheet()->setTitle('Reporte General de Productos');
		  	$object->getActiveSheet()->getStyle('3')->applyFromArray(
		  	array(
		  	'font' => array(
		  	'bold' => TRUE
		)
		)
		);
		  $table_columns = array("CODIGO","NOMBRE DEL PRODUCTO","CATEGORIA", "STOCK MIN","PRECIO VENTA","PRECIO COMPRA");

		  $column = 0;
		  $field = 3;
		  
		  foreach($table_columns as $field)
		  {
		   $object->getActiveSheet()->setCellValueByColumnAndRow($column,3, $field);
		   $column++;
		  }

		  $productosgenerales = $this->Productos_Model->fetch_data();

		  $excel_row = 4;

		  foreach($productosgenerales as $row)
		  {
		 //funcion para dar el tamaño a cada columna del formato excel.
		    $object->getActiveSheet()->getColumnDimension('A')->setWidth(15);
		    $object->getActiveSheet()->getColumnDimension('B')->setWidth(40);
		    $object->getActiveSheet()->getColumnDimension('C')->setWidth(15);
		    $object->getActiveSheet()->getColumnDimension('D')->setWidth(15);
		    $object->getActiveSheet()->getColumnDimension('E')->setWidth(15);
		    $object->getActiveSheet()->getColumnDimension('F')->setWidth(15);
		    

		   $object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->IdProductosGenerales);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->NombreProducto);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row->NombreCategoria);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->StockMinimo);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $row->PrecioVenta);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row->PrecioCompra);
		   
		   $excel_row++;
		}
		  $object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel5');
		  header('Content-Type: application/vnd.ms-excel');
		  header('Content-Disposition: attachment;filename="Reporte General de Productos.xls"');
		  $object_writer->save('php://output');
		  
	}
}