<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará aque el modulo realize sus funciones(Administrador general)
class RServicios extends CI_Controller
{
	//Construtor que manda a traer las librerias de sesión y validación
	//Manda a llamar el modelo
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Administrador/Servicios_Model');
		$this->load->library(array('session','form_validation'));
		$this->load->library('mydompdf'); 
	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal FranquiciasR_view
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->model('reportes/Administrador/Servicios_Model');
		$data["serviciosgenerales"] = $this->Servicios_Model->fetch_data();
    	$this->db->select('*');
		$this->db->join('zona','Zona_IdZona = IdZona','inner');
		$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio = IdTipoServicio','inner');
		$data['consulta']=$this->db->get('serviciosgenerales')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReZona']=$this->Servicios_Model->Buscarzona();
		$data['ReModel']=$this->Servicios_Model-> BuscarModelo();
		$data['ReTipo']=$this->Servicios_Model-> BuscarTipo();
		$this->load->view('reportes/Administrador/Servicios_view',$data);
		$this->load->view('layout/footer');
		}
	}
	public function buscarporzona()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('zona','Zona_IdZona= IdZona','inner');
		$this->db->join('modelo','Modelo_IdModelo= IdModelo','inner');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio = IdTipoServicio','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Servicios_Model->buscarporzona(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReZona']=$this->Servicios_Model->Buscarzona();
		$html=($this->load->view('reportes/Administrador/ReporteSPorZona', $data, true));
      	$this->mydompdf->load_html($html);  
      	$this->mydompdf->set_paper('a4', 'landscape'); 
      	$this->mydompdf->render();
      	$this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      	$this->mydompdf->stream("Reporte Por Zona.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
		}
	}
	public function buscarpormodelo()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
		$this->db->join('zona','Zona_IdZona= IdZona','inner');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio = IdTipoServicio','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Servicios_Model->buscarpormodelo(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReModel']=$this->Servicios_Model->BuscarModelo();
	 	$html=($this->load->view('reportes/Administrador/ReporteSPorModelo', $data, true));
      $this->mydompdf->load_html($html);  
      $this->mydompdf->set_paper('a4', 'landscape'); 
      $this->mydompdf->render();
      $this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      $this->mydompdf->stream("Reporte Por Modelo.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
		}
	}
	public function buscarportipo()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
		$this->db->join('zona','Zona_IdZona= IdZona','inner');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio = IdTipoServicio','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Servicios_Model->buscarportipo(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReTipo']=$this->Servicios_Model->BuscarTipo();
	  	$html=($this->load->view('reportes/Administrador/ReporteSPorTipo', $data, true));
      $this->mydompdf->load_html($html);  
      $this->mydompdf->set_paper('a4', 'landscape'); 
      $this->mydompdf->render();
      $this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      $this->mydompdf->stream("Reporte Por Tipo.pdf", array("Attachment" => false));
    $this->load->view('layout/footer');
		}	
	}
	public function buscar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('reportes/Administrador/BuscarServicios_view',$data);
		$data['ReZona']=$this->Servicios_Model->Buscarzona();
		$data['ReModel']=$this->Servicios_Model->BuscarModelo();
		$data['ReTipo']=$this->Servicios_Model->BuscarTipo();
		$this->load->view('layout/footer');
	}

    public function actiongeneral()
	{	
 	    $this->db->select('*');
		$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
		$this->db->join('zona','Zona_IdZona= IdZona','inner');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio = IdTipoServicio','inner');
		$query=$this->db->get('serviciosgenerales');
        $this->load->model("Servicios_Model");
        $this->load->library("GenerarReporteExcel/excel");
        $object = new PHPExcel();
        $object->setActiveSheetIndex(0);
        $object->getActiveSheet()->setTitle('Reporte General de Servicios');
        $object->getActiveSheet()->getStyle('3')->applyFromArray(
		  array(
		  'font' => array(
		  'bold' => TRUE
		)
		)
		); 
		    $table_columns = array("CÓDIGO","MODELO","NOMBRE","TIPO","PRECIO","ZONA");

		  $column = 0;
		  $field = 3;
		  
		  foreach($table_columns as $field)
		  {
		   $object->getActiveSheet()->setCellValueByColumnAndRow($column,3, $field);
		   $column++;
		  }

		  $serviciosgenerales = $this->Servicios_Model->fetch_data();

		  $excel_row = 4;

		  foreach($serviciosgenerales as $row)
		  {
		 //funcion para dar el tamaño a cada columna del formato excel.
		    $object->getActiveSheet()->getColumnDimension('A')->setWidth(15);
		    $object->getActiveSheet()->getColumnDimension('B')->setWidth(15);
		    $object->getActiveSheet()->getColumnDimension('C') ->setWidth(30);
		    $object->getActiveSheet()->getColumnDimension('D')->setWidth(15);
		    $object->getActiveSheet()->getColumnDimension('E')->setWidth(10);
		    $object->getActiveSheet()->getColumnDimension('F')->setWidth(10);

		   $object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->Codigo_Servicios);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->NombreModelo);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row->NombreServicio);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->NombreTipoServicio);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $row->PreciosServicio);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row->NombreZona);
		  
		   $excel_row++;
		}
		  $object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel5');
		  header('Content-Type: application/vnd.ms-excel');
		  header('Content-Disposition: attachment;filename="Reporte General de Servicios.xls"');
		   // Forzamos a la descarga
		  $object_writer->save('php://output');
	}
}