<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará aque el modulo realize sus funciones(Administrador general)
class RUsuarios extends CI_Controller
{
	//Construtor que manda a traer las librerias de sesión y validación
	//Manda a llamar el modelo
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Administrador/Usuarios_model');
		$this->load->library(array('session','form_validation')); 
		$this->load->library('mydompdf');
	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal FranquiciasR_view
	public function index()
	{	
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->model('reportes/Administrador/Usuarios_model');
		$data["usuarios"] = $this->Usuarios_model->fetch_data();
    	$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias= IdFranquicias','inner');
		$this->db->join('rol','Rol_IdRol = IdRol','inner');
		$data['consulta']=$this->db->get('usuarios')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->Usuarios_model->BuscarFranq();
		$data['ReRol']=$this->Usuarios_model-> BuscarRol();
		$this->load->view('reportes/Administrador/Usuarios_view',$data);
		$this->load->view('layout/footer');
		}
	}
	public function buscarporfranquicia()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias= IdFranquicias','inner');
		$this->db->join('rol','Rol_IdRol = IdRol','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Usuarios_model->buscarporfranquicia(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->Usuarios_model->BuscarFranq();
		$html=($this->load->view('reportes/Administrador/ReportePorFranquicia', $data, true));
      	$this->mydompdf->load_html($html);  
	    $this->mydompdf->set_paper('a4', 'landscape'); 
	    $this->mydompdf->render();
      	$this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      	$this->mydompdf->stream("Reporte Por Franquicia.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
 		}
	}

 	public function buscarporrol()
 	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias= IdFranquicias','inner');
		$this->db->join('rol','Rol_IdRol = IdRol','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Usuarios_model->buscarporrol(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
				);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReRol']=$this->Usuarios_model->BuscarRol();
		$html=($this->load->view('reportes/Administrador/ReportePorRol', $data, true));
      	$this->mydompdf->load_html($html);  
     	$this->mydompdf->set_paper('a4', 'landscape'); 
      	$this->mydompdf->render();
      	$this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      	$this->mydompdf->stream("Reporte de Usuarios Por Rol.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
		}
	}

 	public function buscar()
 	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('reportes/Administrador/BuscarUsuarios_view',$data);
		$data['ReFranq']=$this->Usuarios_model->BuscarFranq();
		$data['ReRol']=$this->Usuarios_model->BuscarRol();
		$this->load->view('layout/footer');
		}
    public function actiongeneral()
 	{
 		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias= IdFranquicias','inner');
		$this->db->join('rol','Rol_IdRol = IdRol','inner');
		$query=$this->db->get('usuarios');
  		$this->load->model("Usuarios_model");
		$this->load->library("GenerarReporteExcel/excel");
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);
		  //$object->getActiveSheet()->px_set_tablename(RUsuarios, franquicias);
		$object->getActiveSheet()->setTitle('Reporte General de Usuarios');
		$object->getActiveSheet()->getStyle('3')->applyFromArray(
		  array(
		  'font' => array(
		  'bold' => TRUE
		)
		)
		);
		  $table_columns = array("NOMBRE","ROL","ESTATUS", "TELÉFONO","FRANQUICIA","DIRECCIÓN","USUARIO");

		  $column = 0;
		  $field = 3;

		  foreach($table_columns as $field)
		  {
		   $object->getActiveSheet()->setCellValueByColumnAndRow($column, 3, $field);
		   $column++;
		  }

		  $usuarios = $this->Usuarios_model->fetch_data();

		  $excel_row = 4;

		  foreach($usuarios as $row)
		  {
		//funcion para dar el tamaño a cada columna del formato excel.
		    $object->getActiveSheet()->getColumnDimension('A')->setWidth(35);
		    $object->getActiveSheet()->getColumnDimension('B')->setWidth(20);
		    $object->getActiveSheet()->getColumnDimension('C')->setWidth(10);
		    $object->getActiveSheet()->getColumnDimension('D')->setWidth(30);
		    $object->getActiveSheet()->getColumnDimension('E')->setWidth(40);
		    $object->getActiveSheet()->getColumnDimension('F')->setWidth(50);
		    $object->getActiveSheet()->getColumnDimension('G')->setWidth(30);
		   


		   $object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->NombreUsuario);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->NombreRol);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row->Estatus);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->NumeroTelefonicoUsuario);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $row->NombreFranquicia);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row->DireccionUsuario);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $row->Usuario);

		   $excel_row++;
		}
		  $object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel5');
		  header('Content-Type: application/vnd.ms-excel');
		  header('Content-Disposition: attachment;filename="Reporte General de Usuarios.xls"');
		  $object_writer->save('php://output');
	}
}