<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará aque el modulo realize sus funciones(Administrador general)
class RServicios extends CI_Controller
{
	//Construtor que manda a traer las librerias de sesión y validación
	//Manda a llamar el modelo
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Franquiciatario/Servicios_Model');
		$this->load->library(array('session','form_validation')); 
		$this->load->library('mydompdf');
	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal FranquiciasR_view
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    		$data['Franquicias']=$this->Servicios_Model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)
    		$this->db->select('*');
    	$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
    	$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
    	$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales=IdServiciosGenerales','join');
    	$this->db->join('tiposervicio','TipoServicio_IdTipoServicio = IdTipoServicio','inner');
			$this->db->where('Franquicias_IdFranquicias',$i);
		$data['consulta']=$this->db->get('serviciosfranquicias')->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReTipo']=$this->Servicios_Model-> BuscarTipo();
		$this->load->view('reportes/Franquiciatario/Servicios_view',$data);
		$this->load->view('layout/footer');
		}
	}
	
	//creacion del reporte general de Usuarios
	public function ReporteSGeneral()
	{
     	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    		$data['Franquicias']=$this->Servicios_Model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)
    		$this->db->select('*');
    	$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
    	$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
    	$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales=IdServiciosGenerales','join');

    	$this->db->join('tiposervicio','TipoServicio_IdTipoServicio = IdTipoServicio','inner');
			$this->db->where('Franquicias_IdFranquicias',$i);
		$data['consulta']=$this->db->get('serviciosfranquicias')->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReTipo']=$this->Servicios_Model-> BuscarTipo();
		$html=($this->load->view('reportes/Franquiciatario/ReporteSGeneral', $data, true));
    	$this->mydompdf->load_html($html);	
    	$this->mydompdf->set_paper('a4', 'portrait'); 
   		$this->mydompdf->render();
	    $this->mydompdf->set_base_path('./assets/dist/css/dompdf.css'); //agregar de nuevo el css
    	$this->mydompdf->stream("Reporte General de Servicios.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
    	}
	}

	public function buscarportipo()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias']=$this->Servicios_Model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)	
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
		$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales=IdServiciosGenerales','join');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio = IdTipoServicio','inner');
		$this->db->where('Franquicias_IdFranquicias',$i);
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Servicios_Model->buscarportipo(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReTipo']=$this->Servicios_Model->BuscarTipo();
		$html=($this->load->view('reportes/Franquiciatario/ReportePorTipoS', $data, true));
    	$this->mydompdf->load_html($html);	
    	$this->mydompdf->set_paper('a4', 'portrait'); 
   		$this->mydompdf->render();
	    $this->mydompdf->set_base_path('./assets/dist/css/dompdf.css'); //agregar de nuevo el css
    	$this->mydompdf->stream("Reporte General de Servicios.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
		}	
	}

	public function buscar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('reportes/Franquiciatario/BuscarServicios_view',$data);
		$data['ReTipo']=$this->Servicios_Model->BuscarTipo();
		$this->load->view('layout/footer');
	}

	public function BuscarFranquicia()
	{
     	$this->db->select('*');
     	$this->db->from('usuarios');
     	$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     	$this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     	$query=$this->db->get();
     	if ($query->num_rows() > 0) { 
     	foreach($query->result() as $row) 
     	$arrDatos[htmlspecialchars($row->IdFranquicias, ENT_QUOTES)] = htmlspecialchars($row->NombreFranquicia, ENT_QUOTES); 
     	$query->free_result(); 
     	return $arrDatos; }
    }
}