<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class ReporteAdeudos extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Franquiciatario/Adeudos_Model');
		$this->load->library(array('session','form_validation'));
		$this->load->helper('url'); 
	}

	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    		$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$this->load->view('reportes/Franquiciatario/ReporteAdeudosV');	
			$this->load->view('layout/footer');
		}
		
	}

	public function reporteVentasServFranquicias(){
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->Adeudos_Model->reporteVentasServFranquicias($inicio,$fin);
      	$data = [];

      if(count($query['generales']->result()) != null ){	
      foreach($query['generales']->result() as $venta) {
           $data[] = array(
                 							 $venta->folio,
                 							 $venta->FolioVenta,
                 							 date("d-m-Y", strtotime($venta->fecha)),
                 							 $venta->nombreCliente,
                 							 $venta->nombreServicio,
                 							 $venta->cantidad,
                                             $venta->vendedor,
                                             $venta->subtotalservicio,
                                             $venta->totalPagar,
                                             $venta->abonoServicio,
                                             $venta->adeudoServicio,
                                             
           );
      }
  }
  	if(count($query['franquicia']->result()) != null ){	
      foreach($query['franquicia']->result() as $venta) {
           $data[] = array(
                 							 $venta->folio,
                 							 $venta->FolioVenta,
                 							 date("d-m-Y", strtotime($venta->fecha)),
                                             $venta->nombreCliente,
                                             $venta->nombreServicio,
                 							 $venta->cantidad,
                                             $venta->vendedor,
                                             $venta->subtotalservicio,
                                             $venta->totalPagar,
                                             $venta->abonoServicio,
                                             $venta->adeudoServicio,
                                             
           );
      }
  }

      echo json_encode($data);
	
	}	

	public function reporteVentasGeneral(){
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->Adeudos_Model->reporteVentasgeneral($inicio,$fin);
	    $data = [];


      foreach($query->result() as $venta) {
           $data[] = array(
                 							 $venta->folio,
                 							 $venta->FolioVenta,
                 							 date("d-m-Y", strtotime($venta->FechaVenta)),
                 							 $venta->ClienteVenta,
                 							 $venta->VendedorUsuario,
                 							 $venta->Comentario,
                 							 $venta->TotalPropina,
                 							 $venta->TotalVenta,
                 							 $venta->TotalVentaGeneral,
                 							 $venta->AbonoVenta,
                 							 $venta->AdeudoVenta,
           );
      }

      echo json_encode($data);
    
		
	}	
		public function reporteVentasgeneralTodas(){
			/*$inicio = $this->input->post('finicio');
			$fin = $this->input->post('ffin');*/
			$query= $this->Adeudos_Model->reporteVentasgeneralTodas();
		    $data = [];


	      foreach($query->result() as $venta) {
	           $data[] = array(
	                 							 $venta->folio,
	                 							 $venta->FolioVenta,
	                 							 date("d-m-Y", strtotime($venta->FechaVenta)),
	                 							 $venta->ClienteVenta,
	                 							 $venta->VendedorUsuario,
	                 							 $venta->Comentario,
	                 							 $venta->TotalPropina,
	                 							 $venta->TotalVenta,
	                 							 $venta->TotalVentaGeneral,
	                 							 $venta->AbonoVenta,
	                 							 $venta->AdeudoVenta,
	           );
	      }

	      echo json_encode($data);
    
		}

		public function reporteVentasPromociones(){
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->Adeudos_Model->reporteVentasPromociones($inicio,$fin);
       	$data = [];

	      foreach($query->result() as $venta) {
	           $data[] = array(
	                 							 $venta->folio,
	                 							 $venta->FolioVenta,
	                 							 date("d-m-Y", strtotime($venta->fechaVenta)),
	                 							 $venta->cliente,
	                 							 $venta->nombrePromo,
	                 							 $venta->cantidad,
	                 							 $venta->vendedor,
	                 							 $venta->subtotalPromo,
	                 							 $venta->totalPagar,
	                 							 /*$venta->descuento,*/
	                 							 $venta->abonoPromo,
	                 							 $venta->adeudoPromo,

	           );
	      }

	      echo json_encode($data);
		}


		public function reporteVentasProductos(){
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->Adeudos_Model->reporteVentasProductos($inicio,$fin);

      	$data = [];


	      foreach($query->result() as $venta) {
	           $data[] = array(
	                 							 $venta->folio,
	                 							 $venta->FolioVenta,
	                 							 date("d-m-Y", strtotime($venta->fechaVenta)),
	                 							 $venta->cliente,
	                 							 $venta->nombreProducto,
	                 							 $venta->cantidad,
	                 							 $venta->vendedor,
	                 							 $venta->subtotalProducto,
	                 							 $venta->totalPagar,
	                 							 $venta->abonoProducto,
	                 							 $venta->adeudoProducto,
	           );
	      }


	      /*$result = array(
	               "draw" => $draw,
	                 "recordsTotal" => $query->num_rows(),
	                 "recordsFiltered" => $query->num_rows(),
	                 "data" => $data
	            );*/


	      echo json_encode($data);
		}


}