<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class ReportesV extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Franquiciatario/Ventas_Model');
		$this->load->library(array('session','form_validation'));
		$this->load->helper('url'); 
	}

	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    		$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$this->load->view('reportes/Franquiciatario/reporteVentas');	
			$this->load->view('layout/footer');
		}
		
	}

	public function reporteVentasServFranquicias(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} 
		else {
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->Ventas_Model->reporteVentasServFranquicias($inicio,$fin);
      	$data = [];

      if(count($query['generales']->result()) != null ){	
      foreach($query['generales']->result() as $venta) {
           $data[] = array(
                 							 $venta->folio,
                 							 $venta->FolioVenta,
                 							 date("d-m-Y H:i:s", strtotime($venta->fecha)),
                 							 $venta->nombreServicio,
                 							 $venta->cantidad,
                                             $venta->nombreCliente,
                                             $venta->vendedor,
                                             $venta->subtotalservicio,
                                             $venta->totalPagar,
                                             $venta->abonoServicio,
                                             $venta->adeudoServicio,
                                             
           );
      }
  }
  	if(count($query['franquicia']->result()) != null ){	
      foreach($query['franquicia']->result() as $venta) {
           $data[] = array(
                 							 $venta->folio,
                 							 $venta->FolioVenta,
                 							 date("d-m-Y H:i:s", strtotime($venta->fecha)),
                 							 $venta->nombreServicio, 
                 							 $venta->cantidad,
                                             $venta->nombreCliente,
                                             $venta->vendedor,
                                             $venta->subtotalservicio,
                                             $venta->totalPagar,
                                             $venta->abonoServicio,
                                             $venta->adeudoServicio,
                                             
           );
      }
  }

      echo json_encode($data);
	}
	}	

	public function reporteVentasGeneral(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} 
		else {
			$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
			$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
			$query= $this->Ventas_Model->reporteVentasgeneral($inicio,$fin);
		    $data = [];


	      foreach($query->result() as $venta) {
	           $data[] = array(
	                 							 $venta->folio,
	                 							 $venta->FolioVenta,
												 date("d-m-Y H:i:s", strtotime($venta->FechaVenta)),
	                 							 $venta->ClienteVenta,
	                 							 $venta->VendedorUsuario,
	                 							 $venta->Comentario,
	                 							 $venta->TotalPropina,
	                 							 $venta->TotalVenta,
	                 							 $venta->TotalVentaGeneral,
	                 							 $venta->AbonoVenta,
	                 							 $venta->AdeudoVenta,
	           );
	      }

	      echo json_encode($data);
	    
		}	
		}	

		public function reporteVentasPromociones(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} 
		else {
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->Ventas_Model->reporteVentasPromociones($inicio,$fin);
       	$data = [];

	      foreach($query->result() as $venta) {
	           $data[] = array(
												 $venta->folio,
												 $venta->FolioVenta,
												  date("d-m-Y H:i:s", strtotime($venta->fechaVenta)),
	                 							//  $venta->fechaVenta,
	                 							 $venta->nombrePromo,
	                 							 $venta->cantidad,
	                 							 $venta->cliente,
	                 							 $venta->vendedor,
	                 							 $venta->subtotalPromo,
	                 							 $venta->totalPagar,
	                 							 /*$venta->descuento,*/
	                 							 $venta->abonoPromo,
	                 							 $venta->adeudoPromo,

	           );
	      }

	      echo json_encode($data);
		}
		}


		public function reporteVentasProductos(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} 
		else {
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->Ventas_Model->reporteVentasProductos($inicio,$fin);

      	$data = [];


	      foreach($query->result() as $venta) {
	           $data[] = array(
	                 							 $venta->folio,
	                 							 $venta->FolioVenta,
	                 							 date("d-m-Y H:i:s", strtotime($venta->fechaVenta)),
	                 							 $venta->nombreProducto,
	                 							 $venta->cantidad,
	                 							 $venta->cliente,
	                 							 $venta->vendedor,
	                 							 $venta->subtotalProducto,
	                 							 $venta->totalPagar,
	                 							 $venta->abonoProducto,
	                 							 $venta->adeudoProducto,
	           );
	      }


	      echo json_encode($data);
		}
		}

		public function reporteVentasGeneralCanceladas(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} 
		else {
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->Ventas_Model->reporteVentasgeneralCanceladas($inicio,$fin);
	    $data = [];


      foreach($query->result() as $venta) {
           $data[] = array(
                 							 $venta->folio,
                 							 $venta->FolioVenta,
                 							 date("d-m-Y H:i:s", strtotime($venta->FechaVenta)),
                 							 $venta->ClienteVenta,
                 							 $venta->VendedorUsuario,
                 							 $venta->Comentario,
                 							 $venta->TotalPropina,
                 							 $venta->TotalVenta,
                 							 $venta->TotalVentaGeneral,
                 							 $venta->AbonoVenta,
                 							 $venta->AdeudoVenta,
                 							 $venta->FechaModificacion,
           );
      }

      echo json_encode($data);
    
		
	}	
	}
}
