<?php
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará a que el módulo realiza sus funciones(Administrador general)
class ServiciosGeneralesA extends CI_Controller
{
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct()
	{
		parent::__construct();
		$this->load->model('servicios/Administrador/serviciosGeneralesA_model');
		$this->load->library(array('session','form_validation'));
	}

	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal listaServiciosGenerales_view y hace la consulta para mostrar todos los servicios generales
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio = IdTipoServicio','inner');	
		$this->db->join('zona','Zona_IdZona = IdZona','inner');
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');				
		$this->db->where('TipoServicio_IdTipoServicio=2');
		$this->db->order_by("NombreModelo","asc");
		$this->db->order_by("NombreZona","asc");
		$data['consulta']=$this->db->get('serviciosgenerales')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('servicios/Administrador/listaServiciosGenerales_view',$data);
		$this->load->view('layout/footer');
		}
	}

		//Función que manda a traer la vista agregaServicioGeneralA_view para registrar el servicio general
	public function agregar()
	{	
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$datos['ReModelo']=$this->serviciosGeneralesA_model->BuscarModelo();
		$datos['ReTipoS']=$this->serviciosGeneralesA_model->BuscarTipoS();
	    $datos['ReCategoria']=$this->serviciosGeneralesA_model->BuscarCategoria();
	    $datos['ReZona']=$this->serviciosGeneralesA_model->BuscarZona();
		$this->load->view('servicios/Administrador/agregaServicioGeneralA_view',$datos);
		$this->load->view('layout/footer');
		}
	}

	//Función que guarda los datos ingresados para poder registrarlos en la base de datos 
	public function guardar()
	{
		$parametro['Codigo_Servicios']=$this->input->post('txt_id');
		$parametro['Modelo_IdModelo']= $this->input->post('Modelo');
		$parametro['NombreServicio']= "SG-".$this->input->post('txt_nombre')." ".$parametro['SesionesServicio']=$this->input->post('txt_sesiones')." "."SESIONES";
		$parametro['TipoServicio_IdTipoServicio'] = $this->input->post('TipoS');
        $parametro['Categoria_IdCategoria'] = $this->input->post('Categoria');
        $parametro['PreciosServicios'] = $this->input->post('text_precio');
        $parametro['DuracionServicio']= $this->input->post('txt_minutos');
		$parametro['SesionesServicio']= $this->input->post('txt_sesiones');
        $parametro['DescripcionServicio'] = $this->input->post('text_descripcion');
        $parametro['ObservacionesServicio'] = $this->input->post('text_observaciones');
        $parametro['ClasificacionServicio'] = $this->input->post('Clasificacion');
        $parametro['Zona_IdZona'] = $this->input->post('Zona');
		$this->serviciosGeneralesA_model->GuardarServicioG($parametro);	
	}


	//Función que manda a traer la vista buscarServiciosGenerales_view y hace la busqueda del servicio seleccionado 
	public function buscar ()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio = IdTipoServicio','inner');	
		$this->db->join('zona','Zona_IdZona = IdZona','inner');
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');		
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->serviciosGeneralesA_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,			
				);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('servicios/Administrador/buscarServiciosGenerales_view', $data);
		$this->load->view('layout/footer');
		}
	}

	//Función que manda a traer la vista editarServiGeneral_view con los datos del servicio seleccionado
	public function editar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->serviciosGeneralesA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdServiciosGenerales=$fila->IdServiciosGenerales;
				$Codigo_Servicios=$fila->Codigo_Servicios;
				$Modelo_IdModelo=$fila->Modelo_IdModelo;
				$NombreServicio = $fila->NombreServicio;
				$TipoServicio_IdTipoServicio=$fila->TipoServicio_IdTipoServicio;
				$Categoria_IdCategoria=$fila->Categoria_IdCategoria;
				$PreciosServicio=$fila->PreciosServicio;
				$DescripcionServicio=$fila->DescripcionServicio;
				$ObservacionesServicio=$fila->ObservacionesServicio;
				$Zona_IdZona=$fila->Zona_IdZona;
				$ClasificacionServicio = $fila->ClasificacionServicio;
				$DuracionServicio = $fila->DuracionServicio;
			}
			$data = array(
				'IdServiciosGenerales' => $IdServiciosGenerales,
				'Codigo_Servicios' => $Codigo_Servicios,
				'Modelo_IdModelo' => $Modelo_IdModelo,
				'NombreServicio' => $NombreServicio,
				'TipoServicio_IdTipoServicio' => $TipoServicio_IdTipoServicio,
				'Categoria_IdCategoria' => $Categoria_IdCategoria,	
				'PreciosServicio' => $PreciosServicio,
			    'DescripcionServicio' => $DescripcionServicio,
			    'ObservacionesServicio' => $ObservacionesServicio,
			    'ClasificacionServicio' => $ClasificacionServicio,
			    'Zona_IdZona' => $Zona_IdZona,
				'DuracionServicio'=>$DuracionServicio
			);
			}else{
				$data ='';
				return FALSE;	
			}
			$data['ReModelo']=$this->serviciosGeneralesA_model->BuscarModelo();
			$data['ReTipoS']=$this->serviciosGeneralesA_model->BuscarTipoS();
	    	$data['ReCategoria']=$this->serviciosGeneralesA_model->BuscarCategoria();
	    	$data['ReZona']=$this->serviciosGeneralesA_model->BuscarZona();
			$this->load->view('layout/header');
			$this->load->view('layout/menuAdmin');
			$this->load->view('servicios/Administrador/editarServiGeneral_view',$data);
			$this->load->view('layout/footer');
		///redirect('servicios/Administrador/serviciosGeneralesA');
		}
	}

	//Función que guarda los datos actualizados del servicio
	public function editarenlace ()
	{
		$IdServiciosGenerales= $this -> uri->segment(5);
		$data=array(
			'IdServiciosGenerales' => $this ->input ->post('IdServiciosGenerales', true),
			'Codigo_Servicios' => $this ->input->post('Codigo_Servicios'),
			'Modelo_IdModelo' => $this ->input ->post('Modelo_IdModelo', true),
			'NombreServicio' => $this ->input ->post('NombreServicio', true),
			'DuracionServicio' => $this->input->post('txt_minutos', true),
			'TipoServicio_IdTipoServicio' => $this ->input->post('TipoServicio_IdTipoServicio', true),
			'Categoria_IdCategoria' => $this ->input->post('Categoria_IdCategoria', true),
			'PreciosServicio' => $this ->input ->post('PreciosServicio', true),
			'DescripcionServicio' => $this ->input->post('DescripcionServicio', true),
			'ObservacionesServicio' => $this ->input ->post('ObservacionesServicio', true),
			'ClasificacionServicio' => $this ->input ->post('ClasificacionServicio', true),
			'Zona_IdZona' => $this ->input ->post('Zona_IdZona', true)
			);
		$this->serviciosGeneralesA_model->editarenlace($IdServiciosGenerales, $data);
	}

	//Función que elimina al servicio
	public function eliminar() {
		 $id= $this->uri->segment(5);
		 $this->serviciosGeneralesA_model->eliminar($id);
		 ;
	}


	//Función que muestra el tipo de modelo 
	public function MostrarModelo()
	{
		$options ="";
		if($this->input->post('IdModelo')){
			$IdTipo=$this->input->post('IdModelo');
			$Nombre=$this->serviciosGeneralesA_model->BuscarModelo($IdTipo);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $tipo_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra el tipo de servicio
	public function MostrarTipoS()
	{
		$options ="";
		if($this->input->post('IdTipoServicio')){
			$IdTipo=$this->input->post('IdTipoServicio');
			$Nombre=$this->serviciosGeneralesA_model->BuscarTipoS($IdTipo);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $tipo_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra el tipo de categoria 
	public function MostrarCategoria()
	{
		$options ="";
		if($this->input->post('IdCategoria')){
			$IdCategoria=$this->input->post('IdCategoria');
			$NombreCategoria=$this->serviciosGeneralesA_model->BuscarCategoria($IdCategoria);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $categoria_name ?></option>
                <?php
			}
		}
	}

	//Funcion que muestra la categoría 
	public function MostrarZona()
	{
		$options ="";
		if($this->input->post('IdZona')){
			$IdZona=$this->input->post('IdZona');
			$Nombre=$this->serviciosGeneralesA_model->BuscarZona($IdZona);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $zona_name ?></option>
                <?php
			}
		}
	}	
}