<?php
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará a que el módulo realiza sus funciones(Administrador general)
class ServiciosAdicionalesF extends CI_Controller
{
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct()
	{
		parent::__construct();
		$this->load->model('servicios/Franquiciatario/serviciosAdicionalesF_model');
		$this->load->library(array('session','form_validation'));
		$this->load->helper(array('url'));
	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal listaServiciosAdicionales y hace la consulta para mostrar todos los servicios adicionales
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data['Franquicias']=$this->serviciosAdicionalesF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
		$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales=IdServiciosGenerales','join');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio=IdTipoServicio','join');	
		$this->db->where("(TipoServicio_IdTipoServicio = '1' OR TipoServicio_IdTipoServicio ='4')");	
		$this->db->where('Franquicias_IdFranquicias',$i);
		$data['consulta']=$this->db->get('serviciosfranquicias')->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');

		$this->load->view('servicios/Franquiciatario/listaServiciosAdicionales',$data);
		$this->load->view('layout/footer');
		}
	}

		//Funcion que manda a traer la vista agregaServicioAdicionalA_view para registrar el servicio adicional
	public function agregar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$datos['ReModelo']=$this->serviciosAdicionalesF_model->BuscarModelo();
		$datos['ReTipoS']=$this->serviciosAdicionalesF_model->BuscarTipoS();
	    $datos['ReCategoria']=$this->serviciosAdicionalesF_model->BuscarCategoria();
	    //$datos['ReZona']=$this->serviciosAdicionalesF_model->BuscarZona($datos);
	    $datos['ReFranquicias']=$this->serviciosAdicionalesF_model->BuscarFranquicia();
  		$datos['ReUsuario']=$this->serviciosAdicionalesF_model->BuscarUsuario();
  		$datos['ReZona']=$this->serviciosAdicionalesF_model->BuscarZona();
		$this->load->view('servicios/Franquiciatario/agregaServicioAdicionalF_view',$datos);
		$this->load->view('layout/footer');
		}
	}
	
	//Funcion que guarda los datos ingresados para poder registrarlos en la base de datos 
	public function guardar()
	{
		$parametro['Codigo_Servicios']="SA".$this->input->post('Franquicia').$parametro['txt_id']= $this->input->post('txt_id');
		$parametro['Modelo_IdModelo']= $this->input->post('Modelo');
		$parametro['NombreServicio']= "SA-".$this->input->post('txt_nombre')." ".$parametro['SesionesServicio']=$this->input->post('txt_sesiones')." "."SESIONES";
		$parametro['TipoServicio_IdTipoServicio']= $this->input->post('TipoS');
		$parametro['Categoria_IdCategoria']= $this->input->post('Categoria');
		$parametro['PreciosServicio']=$this->input->post('text_precio');
		$parametro['SesionesServicio']= $this->input->post('txt_sesiones');
		$parametro['DescripcionServicio']= $this->input->post('text_descripcion');
		$parametro['ObservacionesServicio']=$this->input->post('text_observaciones');
		 $parametro['ClasificacionServicio'] = $this->input->post('Clasificacion');
		$parametro['Zona_IdZona']=$this->input->post('Zona');

		$servicio=$this->db->insert_id();
		
		$parametro['IdServiciosFranquicias']= "FMAS".$this->input->post('Franquicia').$parametro['txt_id']= $this->input->post('txt_id');
		$parametro['ServiciosGenerales_IdServiciosGenerales']= $this->input->post($servicio);
		$parametro['Franquicias_IdFranquicias']=$this->input->post('Franquicia');
		$parametro['Usuarios_IdUsuarios']=$this->input->post('Usuario');
		$this->serviciosAdicionalesF_model->GuardarServicioG($parametro);	
	}

	//Función que manda a traer la vista buscarServiciosAdicionales_view y hace la busqueda del servicio seleccionado 

	//Función que manda a traer la vista editarServiAdicional_view con los datos del servicio seleccionado
	public function editar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->serviciosAdicionalesF_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdServiciosGenerales=$fila->IdServiciosGenerales;
				$IdServiciosFranquicias=$fila->IdServiciosFranquicias;
				$Codigo_Servicios=$fila->Codigo_Servicios;
				$Modelo_IdModelo=$fila->Modelo_IdModelo;
				$NombreServicio = $fila->NombreServicio;
				$TipoServicio_IdTipoServicio=$fila->TipoServicio_IdTipoServicio;
				$Categoria_IdCategoria=$fila->Categoria_IdCategoria;
				$SesionesServicio=$fila->SesionesServicio;
				$PreciosServicio=$fila->PreciosServicio;
				$DescripcionServicio=$fila->DescripcionServicio;
				$ObservacionesServicio=$fila->ObservacionesServicio;
				$Zona_IdZona=$fila->Zona_IdZona;
				$ClasificacionServicio = $fila->ClasificacionServicio;
			}
			$data = array(
				'IdServiciosGenerales'=>$IdServiciosGenerales,
				'IdServiciosFranquicias'=>$IdServiciosFranquicias,
				'Codigo_Servicios' => $Codigo_Servicios,
				'Modelo_IdModelo' => $Modelo_IdModelo,
				'NombreServicio' => $NombreServicio,
				'TipoServicio_IdTipoServicio' => $TipoServicio_IdTipoServicio,
				'Categoria_IdCategoria' => $Categoria_IdCategoria,	
				'SesionesServicio' => $SesionesServicio,
				'PreciosServicio' => $PreciosServicio,
			    'DescripcionServicio' => $DescripcionServicio,
			    'ObservacionesServicio' => $ObservacionesServicio,
			    'ClasificacionServicio' => $ClasificacionServicio,
			    'Zona_IdZona' => $Zona_IdZona);
			}else{
				$data ='';
				return FALSE;	
			}
		$data['ReModelo']=$this->serviciosAdicionalesF_model->BuscarModelo();
		$data['ReTipoS']=$this->serviciosAdicionalesF_model->BuscarTipoS();
	    $data['ReCategoria']=$this->serviciosAdicionalesF_model->BuscarCategoria();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('servicios/Franquiciatario/editarServiAdicional_view',$data);
		$this->load->view('layout/footer');
		}
	}


	//Función que guarda los datos actualizados del servicio
	public function editarenlace ()
	{
		$IdServiciosGenerales= $this -> uri->segment(5);
		$data=array(
			'IdServiciosGenerales' => $this ->input ->post('IdServiciosGenerales', true),
			'Codigo_Servicios' => $this ->input ->post('Codigo_Servicios', true),
			'Modelo_IdModelo' => $this ->input ->post('Modelo_IdModelo', true),
			'NombreServicio' => $this ->input ->post('NombreServicio', true),
			'TipoServicio_IdTipoServicio' => $this ->input->post('TipoServicio_IdTipoServicio', true),
			'Categoria_IdCategoria' => $this ->input->post('Categoria_IdCategoria', true),
			'SesionesServicio' => $this ->input ->post('SesionesServicio', true),
			'PreciosServicio' => $this ->input ->post('PreciosServicio', true),
			'DescripcionServicio' => $this ->input->post('DescripcionServicio', true),
			'ClasificacionServicio' => $this ->input->post('ClasificacionServicio', true),
			'ObservacionesServicio' => $this ->input ->post('ObservacionesServicio', true)
			);
		$this->serviciosAdicionalesF_model->editarenlace($IdServiciosGenerales, $data);
	}

	//Función que elimina al servicio
	public function eliminar() 
	{
		 $id= $this->uri->segment(5);
		 $this->serviciosAdicionalesF_model->eliminar($id);
		 redirect('servicios/Franquiciatario/serviciosAdicionalesF');
	}

	// //Funcion que muestra la zona
	public function MostrarZona()
	{
		$options ="";
		$IdFranquicias=$this->input->post('IdFranquicias');
		if($IdFranquicias){
			$this->load->model('serviciosAdicionalesF_model');
			$zonas=$this->serviciosAdicionalesF_model->BuscarZona($IdFranquicias);
			foreach ($zonas as $zona) {

				echo "<option value='".$zona['Zona_IdZona']."'>".$zona['NombreZona']."</option>";
			}
		}
	}



	//Función que muestra el tipo de modelo 
	public function MostrarModelo()
	{
		$options ="";
		if($this->input->post('IdModelo')){
			$IdTipo=$this->input->post('IdModelo');
			$Nombre=$this->serviciosF_model->BuscarModelo($IdTipo);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $tipo_name ?></option>
                <?php
			}
		}
	}
	
	//Función que muestra el tipo de servicio
	public function MostrarTipoS()
	{
		$options ="";
		if($this->input->post('IdTipoServicio')){
			$IdTipo=$this->input->post('IdTipoServicio');
			$Nombre=$this->serviciosF_model->BuscarTipoS($IdTipo);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $tipo_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra el tipo de categoria
	public function MostrarCategoria()
	{
		$options ="";
		if($this->input->post('IdCategoria')){
			$IdCategoria=$this->input->post('IdCategoria');
			$NombreCategoria=$this->serviciosF_model->BuscarCategoria($IdCategoria);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $categoria_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra la zona
	//public function MostrarZona()
	//{
		//$options ="";
		//if($this->input->post('IdZona')){
		//	$IdZona=$this->input->post('IdZona');
		//	$Nombre=$this->serviciosF_model->BuscarZona($IdZona);
			//foreach ($Nombre as $fila) {
			/*	?>
                <option value="<?php echo $fila->id ?>"><?php echo $zona_name ?></option>
                <?php
			}*/
		//}
	//}

	//Fución que muestra los servicios registrados 
	public function MostrarServicio()
	{
		$options ="";
		if($this->input->post('IdServiciosGenerales')){
			$IdServiciosGenerales=$this->input->post('IdServiciosGenerales');
			$NombreServicio=$this->serviciosAdicionalesF_model->BuscarServicio($IdServiciosGenerales);
			foreach ($NombreProducto as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $categoria_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra la franquicia del usuario logueado
	public function MostrarFranquicia()
	{
		$options ="";
		if($this->input->post('IdFranquicias')){
			$IdFranquicias=$this->input->post('IdFranquicias');
			$NombreFranquicia=$this->serviciosAdicionalesF_model->BuscarFranquicia($IdFranquicias);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $franquicia_name ?></option>
                <?php
			}
		}
	}
	
	//Función que muestra el usuario logueado
	public function MostrarUsuario()
	{
		$options ="";
		if($this->input->post('IdUsuarios')){
			$IdUsuarios=$this->input->post('IdUsuarios');
			$NombreUsuario=$this->serviciosAdicionalesF_model->BuscarUsuario($IdUsuarios);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"></option>
                <?php
			}
		}
	}

	
}
