<?php
/**
* En este modelo se encuentran todas las consultas realizadas en la tabla de agenda(Administrador general)
*/
class AgendaF_model extends CI_Model{
   
  public function getEventos($query, $idClient){
    $data['Franquicias']=$this->agendaF_model->BuscarFranquicia();
      foreach ($data['Franquicias'] as $i => $Franquicias)
    $this->db->select('*');
       
    $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
    $this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
    $this->db->join('clientes','Clientes_IdClientes = IdClientes','inner');
    $this->db->join('cabina','Cabina_IdCabina = IdCabina','inner');
    $this->db->where('IdFranquicias',$i); 
    if ($idClient!= null) {
      $this->db->where('Clientes_IdClientes', $idClient);
    }
    if ($query!=null && $query!="-100") {
      $this->db->where('Cabina_IdCabina', $query); 
    }

    //$this->db->select('IdAgenda id, Cabina_IdCabina cabina, NombreCategoria title, Fecha start, Observaciones  obs,  Usuarios_IdUsuarios usu ,  HoraFin hof,  HoraInicio hoi, Fecha fecha, estatuscitas_IdEstatusCita est, Promociones_IdPromociones promociones, ServiciosFranquicias_IdServiciosFranquicias servicio, IdCategoria categoria, NombreCliente clientes, IdClientes idC, CelularCliente Celular');
    $this->db->from('agenda');
     $this->db->where('`estatuscitas_IdEstatusCita !=',3);
    return $this->db->get()->result();

  }

  // Busqueda de datos
   public function buscarCabinas(){
      $i=$this->session->userdata('IdFranquicia');
      $this->db->select('*');		
      $this->db->where('franquicias_IdFranquicias',$i);
      $this->db->order_by('IdCabina','DESC');
      $query=$this->db->get('cabina');
      if ($query->num_rows() > 0) { 
         return $query->result();
         }
   }

   public function buscarColorCabina($id){
      $this->db->select('colorCabina');		
      $this->db->where('IdCabina',$id);
      $query=$this->db->get('cabina');
      if ($query->num_rows() > 0) { 
         return $query->result()[0]->colorCabina;
	   }
   }

   public function personalExistentes(){
      $i=$this->session->userdata('IdFranquicia');
      $this->db->select('*');
      $this->db->from('usuarios');
      $this->db->where('Franquicias_IdFranquicias',$i);	
      $this->db->where('Estatus','Activo');	
      
      $query=$this->db->get();
      if ($query->num_rows() > 0) 
         return $query->result();
   }

   public function personalIdExistentes(){
      $i=$this->session->userdata('IdFranquicia');
      $this->db->select('IdUsuarios');
      $this->db->from('usuarios');
      $this->db->where('Franquicias_IdFranquicias',$i);	
      $this->db->where('Estatus','Activo');	
      
      $query=$this->db->get();
      if ($query->num_rows() > 0) 
         return $query->result();
   }

   public function BuscaCliente($id){
    $data['Franquicias']=$this->agendaF_model->BuscarFranquicia();
    foreach ($data['Franquicias'] as $i => $Franquicias) 
       $this->db->select('*');
       $this->db->where('Franquicias_IdFranquicias',$i);
       $this->db->where('IdClientes',$id);
       $this->db->order_by('NombreCliente','ASC');
       return $this->db->get('clientes')->result();      
   }

   public function BuscarPorNombreCliente($cliente){
      $id = $this->BuscarIdFranquicia();
      
      $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
      $this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
      $this->db->join('clientes','Clientes_IdClientes = IdClientes','inner');
      $this->db->join('cabina','Cabina_IdCabina = IdCabina','inner');
      $this->db->like('NombreCliente', $cliente,'both');
      $this->db->where('IdFranquicias',$id);


      //$this->db->select('IdAgenda id, Cabina_IdCabina cabina, NombreCategoria title, Fecha start, Observaciones  obs,  Usuarios_IdUsuarios usu ,  HoraFin hof,  HoraInicio hoi, Fecha fecha, estatuscitas_IdEstatusCita est, Promociones_IdPromociones promociones, ServiciosFranquicias_IdServiciosFranquicias servicio, IdCategoria categoria, NombreCliente clientes, IdClientes idC, CelularCliente Celular, NombreCabina');
      //   $this->db->select('IdAgenda id, Cabina_IdCabina cabina, NombreCategoria title, Fecha start, Observaciones  obs,  Usuarios_IdUsuarios usu ,  HoraFin hof,  HoraInicio hoi, Fecha fecha, estatuscitas_IdEstatusCita est, Promociones_IdPromociones promociones, ServiciosFranquicias_IdServiciosFranquicias servicio, IdCategoria categoria, NombreCliente clientes, IdClientes idC, CelularCliente Celular, CorreoCliente Correo');
      $this->db->select("*"); 
      $this->db->from('agenda');
      $this->db->where('agenda.Franquicias_IdFranquicias', $id);
      $this->db->where('`estatuscitas_IdEstatusCita !=',3);
      $this->db->order_by('Fecha','ASC');

      return $this->db->get()->result();
   } 

   public function serviciosGen(){
      $this->db->join('tiposervicio','TipoServicio_IdTipoServicio=IdTipoServicio','inner');
      $this->db->join('categoria','Categoria_IdCategoria=IdCategoria','inner');
      $this->db->join('modelo','Modelo_IdModelo=IdModelo','inner');
      $this->db->join('zona','Zona_IdZona=IdZona','inner');
      $this->db->where('TipoServicio_IdTipoServicio','2');
      $this->db->where('NombreZona',$Zona);
      $this->db->where('Modelo_IdModelo',$Modelo);
      $this->db->order_by('NombreServicio','ASC');
      
      return $this->db->get('serviciosgenerales')->result();
   }

   public function serviciosFranq(){
      $this->db->select('*');
      $this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales = IdServiciosGenerales','inner');
      $this->db->where("(TipoServicio_IdTipoServicio = '1' OR TipoServicio_IdTipoServicio = '4')");
      $this->db->where("Franquicias_IdFranquicias",$this->session->userdata('IdFranquicia'));
      return $this->db->get('serviciosfranquicias')->result();
   }

   public function promociones(){
      /*$this->db->select('*');
      $this->db->where('ClasePromocion','Servicio');
      $this->db->where('franquicias_IdFranquicias' ,$this->session->userdata('IdFranquicia'));
      $this->db->where('Estatus' ,"ACTIVA");
      $this->db->or_where('franquicias_IdFranquicias', null);
      return $this->db->get('promociones')->result();*/


      $this->db->select('*');
      $this->db->from('promociones');
      $this->db->join('tipopromocion','tipopromocion_IdTipoPromocion=IdTipoPromocion','inner');
      $this->db->join('categoria','categoria_IdCategoria=IdCategoria','inner');
      $this->db->where('ClasePromocion','Servicio');
      $this->db->where('Estatus' ,'ACTIVA');
      $this->db->where('franquicias_IdFranquicias' ,$this->session->userdata('IdFranquicia'));  
      $this->db->or_where('franquicias_IdFranquicias', null);
      $this->db->where('Estatus' ,'ACTIVA');
      $this->db->where('Zona_IdZona',"3");
      return $this->db->get()->result();
   }

   /*public function obtenerSesioneXVF($id, $tipo){
      $this->db->select('*');
      $this->db->from('ventas');
      $this->db->join('ventas_has_serviciosfranquicias');
      $this->db->where('IdVentasServicios',$id);
      $result = $this->db->get()->row();
   
      $result2 = $this->infoSer($result->serviciosfranquicias_IdServiciosFranquicias);
   
      if ($result2->tiposervicios_idTipoServicios == 3) {
         # code...
         $res = $this->infoSer($result2->idServicio_TarjetaRegalo);
         $sesiones['cantidadServicios'] = $res->cantidadServicios;
         $sesiones['duracionServicios'] = $res->duracionServicios;
         $sesiones['idServicios'] = $result2->idServicios;
      }else{
         $sesiones['cantidadServicios'] = $result2->cantidadServicios;
         $sesiones['duracionServicios'] = $result2->duracionServicios;
         $sesiones['idServicios'] = $result2->idServicios;
      }
   
      return $sesiones;
   }*/

   public function obtenerSesioneXVFG($id, $tipo){

      if ($tipo=='VF' || $tipo == 'VG') {
         $this->db->select('*');
         $this->db->from('ventas');
         $this->db->join('ventas_has_serviciosfranquicias','IdVentas=ventas_IdVentas','inner');
         $this->db->where('IdVentasServicios',$id);
         $result = $this->db->get()->row();
      }

      switch ($tipo) {
         case 'VF':
            $result2 = $this->obtenerSesioneXSF($result->serviciosfranquicias_IdServiciosFranquicias);
            $sesiones['sesionesServicio'] = $result2->SesionesServicio;
            $sesiones['duracionServicio'] = $result2->DuracionServicio;
            $sesiones['idServicio'] = $result2->IdServiciosFranquicias;
            break;         
         case 'VG':
            $result2 = $this->obtenerSesioneXSG($result->serviciosfranquicias_IdServiciosFranquicias);
            $sesiones['sesionesServicio'] = $result2->SesionesServicio;
            $sesiones['duracionServicio'] = $result2->DuracionServicio;
            $sesiones['idServicio'] = $result2->Codigo_Servicios;
            break; 
         case 'SF':
            $result2 = $this->obtenerSesioneXSF($id);
            $sesiones['sesionesServicio'] = $result2->SesionesServicio;
            $sesiones['duracionServicio'] = $result2->DuracionServicio;
            $sesiones['idServicio'] = $result2->IdServiciosFranquicias;
            break;         
         case 'SG':
            $result2 = $this->obtenerSesioneXSG($id);
            $sesiones['sesionesServicio'] = $result2->SesionesServicio;
            $sesiones['duracionServicio'] = $result2->DuracionServicio;
            $sesiones['idServicio'] = $result2->Codigo_Servicios;
            break;         
         default:
            # code...
            break;
      }   
      return $sesiones;
   }

   public function obtenerSesioneXVP($id,$tipo){
      if ($tipo=='VP') {
         $this->db->select('*');
         $this->db->from('ventas');
         $this->db->join('ventas_has_promociones','IdVentas=ventas_IdVentas','inner');
         $this->db->where('IdVentasPromociones',$id);
         $result = $this->db->get()->row();
      
         $result2 = $this->obtenerSesioneXSP($result->promociones_IdPromociones);

         $sesiones['sesionesServicio'] = $result2->SesionesPromocion;
         $sesiones['duracionServicio'] = $result2->DuracionPromocion;
         $sesiones['idServicio'] = $result2->IdPromociones;
      }else{
         $result2 = $this->obtenerSesioneXSP($id);
         $sesiones['sesionesServicio'] = $result2->SesionesPromocion;
         $sesiones['duracionServicio'] = $result2->DuracionPromocion;
         $sesiones['idServicio'] = $result2->IdPromociones;
      }
   
      return $sesiones;
   }

   public function obtenerSesioneXSG($id){
      $this->db->select('*');
      $this->db->from('serviciosgenerales');
      $this->db->where('Codigo_Servicios',$id);
      $result = $this->db->get()->row();

      return $result;
   }

   public function obtenerSesioneXSF($id){
      $this->db->select('*');
      $this->db->from('serviciosfranquicias');
      $this->db->join("serviciosgenerales","IdServiciosGenerales=ServiciosGenerales_IdServiciosGenerales");
      $this->db->where('IdServiciosFranquicias',$id);
      $result = $this->db->get()->row();

      return $result;
   }

   public function obtenerSesioneXSP($id){
      $this->db->select('*');
      $this->db->from('promociones');
      $this->db->where('IdPromociones',$id);
      $result = $this->db->get()->row();

      return $result;
   }

   public function buscarEstados(){
      $this->db->select('*');		
      $query=$this->db->get('estatuscitas');
      $datos=[];
      if ($query->num_rows() > 0) { 
            $areas=$query->result();
            $i=0;
            $clase="";
   
            foreach($areas as $fila){
               switch($fila->IdEstatusCita)
               {
                  case '1':
                     $clase='confirmada';//'abierto';
                  break;
                  case '2':
                     $clase='pendiente';//'pendienteConfirmar';
                  break;
                  case '3':
                     $clase='cancelada';//'pagoPendiente';
                  break;
                  case '4':
                     $clase='reagendada';
                  break;
                  case '5':
                     $clase='abierto';//'tomadaSistema';
                  break;
                  case '6':
                     $clase='realizada';//'cancelada';
                  break;
                  case '7':
                     $clase='tomadaSistema';//'confirmada';
                  break;
                  case '8':
                     $clase='online';//'realizada';
                  break;
               }
               $datos[$i]['id']=$fila->IdEstatusCita;
               $datos[$i]['nombre']=$fila->NombreEstatusCita;	
               $datos[$i]['clase']=$clase;	
               $i++;			
            }
            
         }
        
         return $datos;
    }

   public function obtenerDatos($id){
      //agregar inner con cliente
      $this->db->select('estatuscitas_IdEstatusCita,IdAgenda,Cabina_IdCabina,Fecha,HoraInicio,HoraFin,DuracionCita,ServiciosFranquicias_IdServiciosFranquicias,Promociones_IdPromociones,SP_Agendado,NumeroSesionesCitas,SesionActual,Clientes_IdClientes,Clientes_IdClientes,Usuarios_IdUsuarios,colorCabina,Observaciones,SesionesFaltantesCitas,SesionesFaltantesAgendar,ventas_IdDetalleVenta,agenda_IdAgenda,NombreCliente,NombreUsuario');
      $this->db->from("agenda");
      $this->db->join('clientes', 'clientes.IdClientes=agenda.Clientes_IdClientes', 'inner');
      $this->db->join('cabina', 'cabina.IdCabina=agenda.Cabina_IdCabina', 'inner');
      $this->db->join('usuarios', 'usuarios.IdUsuarios=agenda.Usuarios_IdUsuarios', 'inner');
      $this->db->where('IdAgenda', $id);
      $query=$this->db->get();
      if ($query->num_rows() > 0) { 
         return $query->result();
      }
   }

   public function BuscarIdFranquicia(){
     $this->db->select('*');
     $this->db->from('usuarios');
     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
              return $row->IdFranquicias; }
    }

    public function buscarAdeudos($id) {
      $i=getIdEstablecimiento();  
      $response=$this->infoEst($i);

      $this->db->select('*');
      $this->db->from('detalleventas');
      $this->db->join('ventas','ventas_idVentas = idVentas','INNER');
      $this->db->where('detalleventas.establecimientos_idEstablecimientos', $i);        
      $this->db->where('clientes_idClientes', $id);
      $this->db->where('adeudoDetalleVentas > 0');
      $this->db->order_by('fechaVentas',  'ASC' ); 
      $query=$this->db->get();
      $res=$query->num_rows();
      $data['datos']=$query->result();
      if (count($data['datos'])>0) {
         # code...
         $data['vigencia']=$response;
         $vigencia=[];
         foreach ($query->result() as $value) {
            if ($response->vigenciaP>0) {               
               array_push($vigencia, date("Y-m-d",strtotime($value->fechaVentas."+".$response->vigenciaP." month")));
            }
         }
         $data['fechaVigencia']=$vigencia;

         $fechaFinFinal = [];
         
         if ($response->vigenciaP>0) { 
            # code...
            $day = date("Y-m-d H:i:s",strtotime($data['fechaVigencia'][0]));
            $day2 = date("Y-m-d H:i:s",strtotime($data['fechaVigencia'][0]."- 6 day"));//.$comp;
            $day3 = date("Y-m-d H:i:s",strtotime($data['fechaVigencia'][0]."- 5 day"));//.$comp;
            $day4 = date("Y-m-d H:i:s",strtotime($data['fechaVigencia'][0]."- 4 day"));//.$comp;
            $day5 = date("Y-m-d H:i:s",strtotime($data['fechaVigencia'][0]."- 3 day"));//.$comp;
            $day6 = date("Y-m-d H:i:s",strtotime($data['fechaVigencia'][0]."- 2 day"));//.$comp;
            $day7 = date("Y-m-d H:i:s",strtotime($data['fechaVigencia'][0]."- 1 day"));//.$comp;
            array_push($fechaFinFinal,$day2, $day3, $day4, $day5, $day6, $day7, $day); 
         }
         // array_push($data['conteo'],$fechaFinFinal);
         $data['conteo']=$fechaFinFinal;
      }
      echo json_encode($data);
   }

   public function BuscarServiciosNombre($codigo){
    /*echo json_encode($codigo);*/
       $Serviciosgenerales   =  $this->BuscarServiciosGenerales($codigo);

      if( count($Serviciosgenerales) != 0 ){
          echo json_encode($Serviciosgenerales);
      }
      else {
        $Serviciosfranquicias =  $this->BuscarServiciosFranquicia($codigo);
          if( count($Serviciosfranquicias) != 0 ){
            echo json_encode( $Serviciosfranquicias);
          }
      }
      
      
   }

   public function BuscarServiciosFranquicia($codigo){

      $this->db->select('*');
      $this->db->from('serviciosfranquicias');
      $this->db->where('IdServiciosFranquicias',(String) $codigo);
      $query = $this->db->get()->result();

      //tomando en  cuenta q no exiten folios repetidos
      $id = $query[0]->ServiciosGenerales_IdServiciosGenerales;

      $this->db->select('*');
      $this->db->from('serviciosgenerales');
      $this->db->where('IdServiciosGenerales',$id);
      $queryResult = $this->db->get()->result();
      return $queryResult;

   }

   public function BuscarServiciosGenerales($codigo){
      $this->db->select('*');
      $this->db->from('serviciosgenerales');
      $this->db->where('Codigo_Servicios',(String) $codigo);
      return $this->db->get()->result();

   }

   public function BuscarPromocionesNombre($promocion){
      $this->db->select('*');
      $this->db->from('promociones');
      $this->db->where('FolioPromocion',$promocion);
      echo  json_encode($this->db->get()->result());
   }

   public function buscarporcabina($query) {// Realiza una consulta a la bd para buscar la agenda de la franquicia seleccionada
      $data['Franquicias']=$this->agendaF_model->BuscarFranquicia();
      foreach ($data['Franquicias'] as $i => $Franquicias)
         $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
         $this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
         $this->db->join('clientes','Clientes_IdClientes = IdClientes','inner');
         $this->db->join('cabina','Cabina_IdCabina = IdCabina','inner');
         $this->db->where('IdFranquicias',$i);
         $this->db->where('Cabina_IdCabina', $query);
         $this->db->where('`estatuscitas_IdEstatusCita !=',3);
         //   $this->db->select('IdAgenda id, Cabina_IdCabina cabina, NombreCategoria title, Fecha start, Observaciones  obs,  Usuarios_IdUsuarios usu ,  HoraFin hof,  HoraInicio hoi, Fecha fecha, estatuscitas_IdEstatusCita est, Promociones_IdPromociones promociones, ServiciosFranquicias_IdServiciosFranquicias servicio, IdCategoria categoria, NombreCliente clientes, NombreCabina');
         //$this->db->select('IdAgenda id, Cabina_IdCabina cabina, NombreCategoria title, Fecha start, Observaciones  obs,  Usuarios_IdUsuarios usu ,  HoraFin hof,  HoraInicio hoi, Fecha fecha, estatuscitas_IdEstatusCita est, Promociones_IdPromociones promociones, ServiciosFranquicias_IdServiciosFranquicias servicio, IdCategoria categoria, NombreCliente clientes, IdClientes idC, CelularCliente Celular, NombreCabina');
         $this->db->select("*");
         $this->db->from('agenda');
         return $this->db->get()->result();

   }

   public function getEventos1(){
      $this->db->select('*');
      $this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
      $this->db->join('clientes','Clientes_IdClientes = IdClientes','inner');
      $this->db->select('IdAgenda id, NombreCategoria title, Fecha start, NombreCliente NC');
      $this->db->from('agenda');

      return $this->db->get()->result();
   }
 
   public function updEvento2($data){
      $this->db->set('Observaciones', $data['descripcion']);
      $campos = array(
         /*'Franquicias_IdFranquicias' =>( int ) $this->BuscarIdFranquicia(),*/
         /*'Clientes_IdClientes' => ( int ) $data['nombreCliente'],*/
         // 'Categoria_IdCategoria' =>( int ) $data['idCategoria'],
         'ServiciosFranquicias_idServiciosFranquicias' => $data['codeService'],
         'promociones_idPromociones' =>$data['codePromo'],
         'Fecha' => $data['fechaAgendada'],
         'HoraInicio' => $data['horaInicio'],
         'HoraFin' => $data['horaFin'],
         'Cabina_IdCabina' =>( int ) $data['idCabina'] ,
         'estatuscitas_IdEstatusCita' =>( int ) $data['estado'],
         'Observaciones' => $data['descripcion'],
         'Usuarios_IdUsuarios' =>( int ) $data['idUserChange'],
         /*      'IdAgenda' =>( int ) $data['idEvento']  */
      );
      /*return $campos;*/

      $this->db->where('IdAgenda',( int ) $data['idEvento']);
      $this->db->update('agenda',$campos);
    
      if ($this->db->affected_rows() > 0) {
         return 1;
      }else{
         return 0;
      }
   }

   public function deleteEvento($id){
      $this->db->where('IdAgenda', $id);
      return $this->db->delete('agenda');
   }

   public function guardar($parametro){
      $campos=array(         
         'Clientes_IdClientes' => $parametro['Clientes_IdClientes'],
         'Categoria_IdCategoria' => $parametro['Categoria_IdCategoria'],
         'ServiciosFranquicias_IdServiciosFranquicias' => $parametro['ServiciosFranquicias_IdServiciosFranquicias'],
         'Promociones_IdPromociones' => $parametro['Promociones_IdPromociones'],
         'Fecha' => $parametro['Fecha'],
         'HoraInicio' => $parametro['HoraInicio'],
         'HoraFin' => $parametro['HoraFin'],
         'estatuscitas_IdEstatusCita' => $parametro['estatuscitas_IdEstatusCita'],
         'Cabina_IdCabina' => $parametro['Cabina_IdCabina'],
         'Observaciones' => $parametro['Observaciones'],
         'Usuarios_IdUsuarios' => $parametro['Usuarios_IdUsuarios'],
         'Franquicias_IdFranquicias' => $parametro['Franquicias_IdFranquicias']
      );
 
      $this->db->insert('agenda',$campos);
   }

   public function nuevaCita($parametro){
      $campos=array(          
         'Clientes_IdClientes' => $parametro['Clientes_IdClientes'],
         'Categoria_IdCategoria' => $parametro['Categoria_IdCategoria'],
         'ServiciosFranquicias_IdServiciosFranquicias' => $parametro['ServiciosFranquicias_IdServiciosFranquicias'],
         'Promociones_IdPromociones' => $parametro['Promociones_IdPromociones'],
         'Fecha' => $parametro['Fecha'],
         'HoraInicio' => $parametro['HoraInicio'],
         'HoraFin' => $parametro['HoraFin'],
         'estatuscitas_IdEstatusCita' => $parametro['estatuscitas_IdEstatusCita'],
         'Cabina_IdCabina' => $parametro['Cabina_IdCabina'],
         'Observaciones' => $parametro['Observaciones'],
         'Usuarios_IdUsuarios' => $parametro['Usuarios_IdUsuarios'],
         'Franquicias_IdFranquicias' => $parametro['Franquicias_IdFranquicias']
      );

      $query=$this->db->insert('agenda',$campos);
      $res=$this->db->affected_rows();
      if ($res > 0) { 
         return TRUE;
      }  
   }

   public function BuscarServicios(){
      $this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales = IdServiciosGenerales','inner');
      $query = $this->db->get_where('serviciosfranquicias' ,  array ( 'Franquicias_IdFranquicias'=> 3));
      if ($query->num_rows() > 0) { 
         foreach($query->result() as $row) 
            $arrDatos[htmlspecialchars($row->IdServiciosFranquicias, ENT_QUOTES)] = htmlspecialchars($row->NombreServicio, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; 
      }
   }

   //Consulta que la promociones locales/emergetes del cliente a que se le realizara la cita
   public function BuscarPromocionesLocales(){
      //$this->db->select('*');
      // $data['Zona']=$this->agendaA_models->BuscarZona();
      // foreach ($data['Zona'] as $i => $Zona) 
      // $this->db->where('Zona_IdZona',$i);
      $this->db->where("(TipoPromocion_IdTipoPromocion = '2' OR TipoPromocion_IdTipoPromocion ='4')");
      $this->db->where('Estatus','ACTIVA');
      $this->db->order_by('NombrePromocion',"ASC");
      $query=$this->db->get('promociones');
      if ($query->num_rows() > 0) { 
         foreach($query->result() as $row) 
            $arrDatos[htmlspecialchars($row->IdPromociones, ENT_QUOTES)] = htmlspecialchars($row->NombrePromocion, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; 
      }
   }

   //Consulta que la promociones Fijas/Institucionales del cliente a que se le realizara la cita
   public function BuscarPromocionesinstitucionales(){
      $this->db->where("(TipoPromocion_IdTipoPromocion = '1' OR TipoPromocion_IdTipoPromocion ='3')");
      $this->db->where('Estatus','ACTIVA');
      $this->db->order_by('NombrePromocion',"ASC");
      $query=$this->db->get('promociones');
      if ($query->num_rows() > 0) { 
         foreach($query->result() as $row) 
            $arrDatos[htmlspecialchars($row->IdPromociones, ENT_QUOTES)] = htmlspecialchars($row->NombrePromocion, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; 
      }
   }

   public function BuscarCategoria(){
      $query = $this->db-> query('SELECT IdCategoria,NombreCategoria FROM categoria'); 
      if ($query->num_rows() > 0) { 
         foreach($query->result() as $row) 
            $arrDatos[htmlspecialchars($row->IdCategoria, ENT_QUOTES)] = htmlspecialchars($row->NombreCategoria, ENT_QUOTES); 
               $query->free_result(); 
               return $arrDatos; 
      }
   }

   public function BuscarUsuario(){
      $data['Franquicias']=$this->agendaF_model->BuscarFranquicia();
      foreach ($data['Franquicias'] as $i => $Franquicias)
         $this->db->select('*');
         $this->db->from('usuarios');
         $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
         $this->db->where('Franquicias_IdFranquicias',$i);
         $this->db->where('Estatus', 'Activo');
  
         // $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
         //$query = $this->db-> query('SELECT IdUsuarios,NombreUsuario FROM usuarios'); 
         $query=$this->db->get();
         if ($query->num_rows() > 0) { 
            foreach($query->result() as $row) 
               $arrDatos[htmlspecialchars($row->IdUsuarios, ENT_QUOTES)] = htmlspecialchars($row->NombreUsuario, ENT_QUOTES); 
               $query->free_result(); 
               return $arrDatos; 
         }
   }

   public function BuscarCliente(){
      $query = $this->db-> query('SELECT IdClientes,NombreCliente FROM clientes'); 
      if ($query->num_rows() > 0) { 
         foreach($query->result() as $row) 
            $arrDatos[htmlspecialchars($row->IdClientes, ENT_QUOTES)] = htmlspecialchars($row->NombreCliente, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; 
      }
   }

   public function BuscarEstatusCita(){
      $query = $this->db-> query('SELECT IdEstatusCita,NombreEstatusCita FROM estatuscitas'); 
      if ($query->num_rows() > 0) { 
         foreach($query->result() as $row) 
            $arrDatos[htmlspecialchars($row->IdEstatusCita, ENT_QUOTES)] = htmlspecialchars($row->NombreEstatusCita, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; 
      }
   }

   public function BuscarPromociones(){
      $this->db->join('promociones','Promociones_IdPromociones = IdPromociones','inner');

      $query = $this->db->get_where('promociones' ,  array ( 'Franquicias_IdFranquicias'=> 2 ));

      if ($query->num_rows() > 0) { 
         foreach($query->result() as $row) 
            $arrDatos[htmlspecialchars($row->IdPromocionesFranquicias, ENT_QUOTES)] = htmlspecialchars($row->NombrePromocion, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; 
      }
   }

   // Realiza una consulta a la bd para buscar las franquicias que existen y poder mandar el resultado
   public function BuscarFranquicia(){
      $this->db->select('*');
      $this->db->from('usuarios');
      $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
      $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
      $query=$this->db->get();
      
      if ($query->num_rows() > 0) { 
         foreach($query->result() as $row) 
            $arrDatos[htmlspecialchars($row->IdFranquicias, ENT_QUOTES)] = htmlspecialchars($row->NombreFranquicia, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; 
      }
   }
    
   public function BuscarCabina(){
      $data['Franquicias']=$this->agendaF_model->BuscarFranquicia();
      foreach ($data['Franquicias'] as $i => $Franquicias)
         $this->db->select('*'); 
         $this->db->from('cabina');
         // $this->db->join('cabina','IdCabina=IdCabina','inner');
         $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
         $this->db->where('Franquicias_IdFranquicias',$i);
         //$this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
         $query=$this->db->get();
         if ($query->num_rows() > 0) { 
            foreach($query->result() as $row) 
               $arrDatos[htmlspecialchars($row->IdCabina, ENT_QUOTES)] = htmlspecialchars($row->NombreCabina, ENT_QUOTES); 
               $query->free_result(); 
               return $arrDatos; 
         }else{
            //     echo "<script>alert('No se ha encontrado niguna cabina asignada a su franquicia');</script>";
            // redirect('acceso/acceso','refresh');
            echo "<script>alert('No se ha encontrado niguna cabina asignada a su franquicia');
                 window.location.href='".base_url()."acceso/acceso';
                 </script>";
         }
   }

   public function BuscarZona(){
      $this->db->select('*');
      $this->db->from('usuarios');
      $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
      $this->db->join('zona','Zona_IdZona=IdZona','inner');
      $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
      $query=$this->db->get();
      if ($query->num_rows() > 0) { 
         foreach($query->result() as $row) 
            $arrDatos[htmlspecialchars($row->IdZona, ENT_QUOTES)] = htmlspecialchars($row->NombreZona, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; 
      }
   }
         
   public function BuscarModelo(){
      $this->db->select('*');
      $this->db->from('usuarios');
      $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
      $this->db->join('modelo','Modelo_IdModelo=IdModelo','inner');
      $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
      $query=$this->db->get();

      if ($query->num_rows() > 0) { 
         foreach($query->result() as $row) 
            $arrDatos[htmlspecialchars($row->IdModelo, ENT_QUOTES)] = htmlspecialchars($row->IdModelo, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; 
      }
   }
      
   public function BuscarServiciosFranquicias(){
      $this->db->select('*');
      $this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales = IdServiciosGenerales','inner');
      return $this->db->get('serviciosfranquicias')->result();
   }
   
   public function BuscarServiciosGeneral(){
      //$data['Zona']=$this->agendaF_model->BuscarZona();
      //foreach ($data['Zona'] as $a => $Zona) 
      $data['Modelo']=$this->agendaF_model->BuscarModelo();
      foreach ($data['Modelo'] as $j => $Modelo)
         $this->db->select('*');
         $this->db->where('Zona_IdZona',3);
         $this->db->where('Modelo_IdModelo',$j);
         $this->db->WHERE("(TipoServicio_IdTipoServicio = '2' OR TipoServicio_IdTipoServicio = '3')");
         return $this->db->get('serviciosgenerales')->result();
   }

   public function personalTrabajando($fecha, $inicio, $fin, $idCita, $idPersonal){
      /********************************************************/
      //SELECT DISTINCT usuarios_idUsuarios FROM `detallecitas` WHERE fechaDetalleCitas = '2020-08-26' and horaInicioDetalleCitas = '13:00:00' and horaFinDetalleCitas = '14:00:00'
      $i=$this->session->userdata('IdFranquicia');
      $this->db->distinct();
      $this->db->select('*');
      $this->db->from('agenda');
      //$this->db->join('citas', 'detallecitas.citas_idCitas = citas.idCitas', 'inner');
      $this->db->where('Fecha', date("Y-m-d",strtotime($fecha)));
      $this->db->where('estatuscitas_IdEstatusCita !=', '3');
      $this->db->where('estatuscitas_IdEstatusCita !=', '7');
      $this->db->where('Franquicias_IdFranquicias', $i);
      // $this->db->where('horaInicioDetalleCitas =', $inicio);
      // $this->db->where('horaFinDetalleCitas =', $fin);
      if ($idCita != null || $idCita!="") {
         # code...
         $this->db->where('IdAgenda !=', $idCita);
      }
      $query =$this->db->get()->result_array();

      return $query;//$this->db->get_compiled_select();

      /*********************************************************************/
   }

   public function personalExistentesCambio($dia,$inicio,$fin,$usuarios, $idPersonal){
      /*SELECT * FROM `horarios` 
         INNER JOIN usuarios 
         ON usuarios.idUsuarios=horarios.usuarios_idUsuarios 
         WHERE horarios.establecimientos_idEstablecimientos = 55 
         AND `sabado` = 1 
         and `horaIniSabado` <= '21:00:00' 
         and `horaFinSabado` >= '21:30:00' 
          and estados_idEstados = '1'
      */
          //agregar where not in($array) en el modelo
      $i=$this->session->userdata('IdFranquicia');
      $diaActual = strtolower($dia);
      $this->db->select('*');
      $this->db->from('horarios');
      $this->db->join('usuarios','usuarios.IdUsuarios=horarios.IdUsuarios','INNER');   
      if (count($usuarios)>0) {
         # code...
         $this->db->where_not_in('horarios.IdUsuarios',  $usuarios);
      }
      $this->db->where('usuarios.Franquicias_IdFranquicias',$i); 
      $this->db->where($diaActual,1);  
      $this->db->where('horaIni'.$dia.' <= ',$inicio);   
      $this->db->where('horaFin'.$dia.' >= ',$fin);   
      $this->db->where('Estatus','Activo'); 
      //$query = $this->db->get();

      $query=$this->db->get()->result_array();
      if (count($query) > 0) {
         return $query;//->result_array();
      }else{
         return null;
      }
   }
   public function Buscarpromos(){
      $this->db->select('*');
      $this->db->where('ClasePromocion','Servicio');
      return $this->db->get('promociones')->result();
   }
 
   //  public function nombreSer($id)
      //  {
      //        $this->db->select('NombreServicio');
      //        $this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales=IdServiciosGenerales','inner');
      //        $this->db->where('IdServiciosFranquicias',$id);
      //        $query=$this->db->get('serviciosfranquicias');
      //        if ($query->num_rows() > 0) { 
      //          foreach($query->result() as $row) 
      //           {
      //              $nombre=$row->NombreServicio;
      //            return $nombre; 
      //           }              
      //         }else{
      
      //               $this->db->select('NombreServicio');
      //              $this->db->where('Codigo_Servicios',$id);
      //              $query2=$this->db->get('serviciosgenerales');
      //              if ($query2->num_rows() > 0) { 
      //                foreach($query2->result() as $row2) 
      //                 {
      //                    $nombre=$row2->NombreServicio;
      //                  return $nombre; 
      //                 }              
      //               }else{
      //                  return "";
      //               }
      //         }
      //  }
      //  public function nombrePromocion($id)
      //  {
      //    $this->db->select('NombrePromocion');
      //    $this->db->where('FolioPromocion',$id);
      //    $query=$this->db->get('promociones');
      //    if ($query->num_rows() > 0) { 
      //       foreach($query->result() as $row) 
      //       {
      //          $nombre=$row->NombrePromocion;
      //          return $nombre; 
      //       }              
      //       }else{
      //          return "";
      //       }
   //  }

   public function nombreTratamiento($id1, $id2){
      if($id1!=''){
         // return $id1;
         $this->db->select('NombreServicio');
         $this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales=IdServiciosGenerales','inner');
         $this->db->where('IdServiciosFranquicias',$id1);
         $query=$this->db->get('serviciosfranquicias');
         if ($query->num_rows() > 0) { 
           foreach($query->result() as $row) {
               $nombre=$row->NombreServicio;
               return $nombre; 
            }              
         }else{  
            $this->db->select('NombreServicio');
            $this->db->where('Codigo_Servicios',$id1);
            $query2=$this->db->get('serviciosgenerales');
            if ($query2->num_rows() > 0) { 
               foreach($query2->result() as $row2){
                  $nombre=$row2->NombreServicio;
                  return $nombre; 
               }              
            }else{
               return "";
            }
         }
      }else{
         $this->db->select('NombrePromocion');
         $this->db->where('FolioPromocion',$id2);
         $query=$this->db->get('promociones');
         if ($query->num_rows() > 0) { 
            foreach($query->result() as $row) {
               $nombre=$row->NombrePromocion;
               return $nombre; 
            }              
         }else{
            return "";
         }
      }
   }

   public function buscarCitasAgenda($cabina, $fecha, $horaInicio, $horaFin){
      $i=$this->session->userdata('IdFranquicia');
      $this->db->select('*');
      $this->db->from("agenda");
      $this->db->where('Cabina_IdCabina', $cabina);
      $this->db->where('Fecha', $fecha);
      $this->db->where('estatuscitas_IdEstatusCita !=', '3');
      $this->db->where('estatuscitas_IdEstatusCita !=', '7');
      $this->db->where('Franquicias_IdFranquicias', $i);
      $query=$this->db->get();
      foreach($query->result() as $fila)
      {	
         // return $fila;
         // exit();
         if(strtotime($fila->HoraInicio) == strtotime($horaInicio) && strtotime($fila->HoraFin)==strtotime($horaFin)){
            return 1;
         }elseif(strtotime($fila->HoraInicio) <= strtotime($horaInicio) && strtotime($horaFin) <= strtotime($fila->HoraFin)) {
            return 1;
         }elseif(strtotime($horaInicio) <= strtotime($fila->HoraInicio) && strtotime($fila->HoraFin) <= strtotime($horaFin)) {
            return 1;
         }elseif(strtotime($horaInicio) < strtotime($fila->HoraInicio) && strtotime($fila->HoraInicio) < strtotime($horaFin)) {
            return 1;
         }elseif(strtotime($horaInicio) < strtotime($fila->HoraFin) && strtotime($fila->HoraFin) < strtotime($horaFin)) {
            return 1;
         }
      }
   }

   public function guardarCita($campos){
      $this->db->insert('agenda', $campos);
      $id=$this->db->insert_id();
      return $id;
   }

   public function actSesion($data, $id){
      $this->db->set($data, $id);

      $this->db->where('IdAgenda',$id);
      $this->db->update('agenda',$data);
    
      if ($this->db->affected_rows() > 0) {
         return 1;
      }else{
         return 0;
      }
   }
 
   public function buscarCitas($inicio, $fin, $cabina, $status) {
      $agenda=[];
      $seviciosA=$this->citaServiciosA($inicio, $fin, $cabina, $status);
      $seviciosG=$this->citaServiciosG($inicio, $fin, $cabina, $status);
      $promociones=$this->citaPromociones($inicio, $fin, $cabina, $status);
      if($seviciosA!=FALSE){
         foreach($seviciosA as $sa){
            $agenda[] = array(
               $sa->NombreCliente, 
               $sa->NombreServicio, 
               $sa->NombreCabina, 
               $sa->NombreEstatusCita,
               date("d-m-Y", strtotime($sa->Fecha)), 
               date("g:i a",strtotime($sa->HoraInicio)),
               date("g:i a",strtotime($sa->HoraFin)),
               $sa->Observaciones,
               $sa->NombreUsuario,
            );
         }
      }

      if($seviciosG!=FALSE) {
         foreach($seviciosG as $sa){
            $agenda[] = array(
               $sa->NombreCliente, 
               $sa->NombreServicio, 
               $sa->NombreCabina, 
               $sa->NombreEstatusCita,
               date("d-m-Y", strtotime($sa->Fecha)), 
               date("g:i a",strtotime($sa->HoraInicio)),
               date("g:i a",strtotime($sa->HoraFin)),
               $sa->Observaciones,
               $sa->NombreUsuario,
            );
         }
      }

      if($promociones!=FALSE){
         foreach($promociones as $pr){
            $agenda[] = array(
               $pr->NombreCliente, 
               $pr->NombrePromocion, 
               $pr->NombreCabina, 
               $pr->NombreEstatusCita,
               date("d-m-Y", strtotime($pr->Fecha)), 
               date("g:i a",strtotime($pr->HoraInicio)),
               date("g:i a",strtotime($pr->HoraFin)),
               $pr->Observaciones,
               $pr->NombreUsuario,
           );
         }
      }
      echo json_encode($agenda);   
   }

   public function citaServiciosA($inicio, $fin, $cabina, $status) {
      $data['Franquicias']=$this->agendaF_model->BuscarFranquicia();
      foreach ($data['Franquicias'] as $i => $Franquicias)
         $this->db->select('*');
         $this->db->join('clientes','Clientes_IdClientes = IdClientes','inner');
         $this->db->join('cabina','Cabina_IdCabina = IdCabina','inner');
         $this->db->join('estatuscitas','estatuscitas_IdEstatusCita = IdEstatusCita','inner'); 
         $this->db->join('serviciosfranquicias','ServiciosFranquicias_IdServiciosFranquicias = IdServiciosFranquicias','inner');      
         $this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales = IdServiciosGenerales','inner'); 
         $this->db->join('usuarios','agenda.Usuarios_IdUsuarios = 	IdUsuarios','inner');
         $this->db->where('agenda.Franquicias_IdFranquicias',$i);
         $this->db->where('agenda.Fecha >=', $inicio.' 00:00:00');
         $this->db->where('agenda.Fecha <=', $fin.' 23:59:59');

         if($cabina!=""){
            $this->db->where('IdCabina', $cabina);
         }

         if($status!=""){
            $this->db->where('IdEstatusCita', $status);
         }

         $query=$this->db->get('agenda');

      if ($query->num_rows() > 0) {         
            return $query->result();    
      }else{
         return FALSE;
      }
   }

   public function citaServiciosG($inicio, $fin, $cabina, $status) {
      $data['Franquicias']=$this->agendaF_model->BuscarFranquicia();
      foreach ($data['Franquicias'] as $i => $Franquicias)
         $this->db->select('*');
         $this->db->join('clientes','Clientes_IdClientes = IdClientes','inner');
         $this->db->join('cabina','Cabina_IdCabina = IdCabina','inner');
         $this->db->join('estatuscitas','estatuscitas_IdEstatusCita = IdEstatusCita','inner');       
         $this->db->join('serviciosgenerales','ServiciosFranquicias_IdServiciosFranquicias = Codigo_Servicios','inner'); 
         $this->db->join('usuarios','agenda.Usuarios_IdUsuarios = 	IdUsuarios','inner');
         $this->db->where('agenda.Franquicias_IdFranquicias',$i);
         $this->db->where('agenda.Fecha >=', $inicio.' 00:00:00');
         $this->db->where('agenda.Fecha <=', $fin.' 23:59:59');

         if($cabina!=""){
            $this->db->where('IdCabina', $cabina);
         }

         if($status!=""){
            $this->db->where('IdEstatusCita', $status);
         }

         $query=$this->db->get('agenda');
      if ($query->num_rows() > 0) {         
         return $query->result();    
      }else{
         return FALSE;
      }
   }
   
   public function citaPromociones($inicio, $fin, $cabina, $status) {
      $data['Franquicias']=$this->agendaF_model->BuscarFranquicia();
      foreach ($data['Franquicias'] as $i => $Franquicias)
         $this->db->select('*');
         $this->db->join('clientes','Clientes_IdClientes = IdClientes','inner');
         $this->db->join('cabina','Cabina_IdCabina = IdCabina','inner');
         $this->db->join('estatuscitas','estatuscitas_IdEstatusCita = IdEstatusCita','inner');       
         $this->db->join('promociones','Promociones_IdPromociones = 	FolioPromocion','inner'); 
         $this->db->join('usuarios','agenda.Usuarios_IdUsuarios = 	IdUsuarios','inner');
         $this->db->where('agenda.Franquicias_IdFranquicias',$i);
         $this->db->where('agenda.Fecha >=', $inicio.' 00:00:00');
         $this->db->where('agenda.Fecha <=', $fin.' 23:59:59');

         if($cabina!=""){
            $this->db->where('IdCabina', $cabina);
         }

         if($status!=""){
            $this->db->where('IdEstatusCita', $status);
         }

         $query=$this->db->get('agenda');
      if ($query->num_rows() > 0) {         
         return $query->result();    
      }else{
         return FALSE;
      }
   }

   //  public function datosCliente($id)
      //  {
      //    $this->db->select('CelularCliente, CorreoCliente');
      //    $this->db->where('IdClientes', $id);
      //    $query=$this->db->get('clientes');
      //       if ($query->num_rows() > 0) { 
      //        foreach($query->result() as $row) 
      //         {
      //            $data=$row->CelularCliente ."\r\n".$row->CorreoCliente;
      //          return $data; 
      //         }              
      //       }else{
      //          return "";  
      //       }
   //  }

   public function periodoCancelacion(){
      $i=$this->session->userdata('IdFranquicia');
      $this->db->select('*');
      $this->db->from('franquicias');
      $this->db->where('IdFranquicias', $i);
      $response = $this->db->get()->row();

      return $response;
   }

   public function actualizaCita($idCita, $campos){
      $this->db->where('IdAgenda',$idCita);
      $this->db->update('agenda',$campos);
         if ($this->db->affected_rows() == 1) {
            return 1;
         }else{
            return 0;//$this->db->last_query();
         }
   }

   public function AlerTomadoS(){
      $this->db->select('timeAstatusC');
      $this->db->from('franquicias');
      $this->db->where('IdFranquicias',  $this->session->userdata('IdFranquicia'));
      $data = $this->db->get();

      if ($data->num_rows()>0) {
        return $data->row();
      }else{
        return 1;
      }
   }

   public function citasActuales($dateTimeAnt, $dateTimeAct){
      $this->db->select('*');
      $this->db->from('agenda');
      $this->db->join('clientes', 'agenda.Clientes_IdClientes=clientes.IdClientes');
      $this->db->join('estatuscitas', 'agenda.estatuscitas_IdEstatusCita = estatuscitas.IdEstatusCita');
      $this->db->where('agenda.Franquicias_IdFranquicias', $this->session->userdata('IdFranquicia'));
      $this->db->where('agenda.estatuscitas_IdEstatusCita !=', 1);//confirmada
      $this->db->where('agenda.estatuscitas_IdEstatusCita !=', 3);//cancelada
      $this->db->where('agenda.estatuscitas_IdEstatusCita !=', 6);//realizada
      $this->db->where('agenda.estatuscitas_IdEstatusCita !=', 7);//tomada por sistema
      $this->db->where('agenda.Fecha', $dateTimeAnt[0]);
      $this->db->where('agenda.HoraInicio <=', $dateTimeAct[1]);
      $query = $this->db->get();
   
      if ($query->num_rows()>0) {
         return $query->result_array();
      }else{
         return false;
      }
   }

   public function registrarInicio($time){
      $campos = array(
         'timeAstatusC' => $time
      );
   
      $this->db->where('IdFranquicias', $this->session->userdata('IdFranquicia'));
      $this->db->update('franquicias', $campos);
   
      $filas = $this->db->affected_rows();
      if ($filas) {
         return $filas;
      }else{
         return false;
      }
   }

   public function ActualizarCitas($data, $id){
      $this->db->where('IdAgenda', $id);
      $this->db->update('agenda', $data);
      $response = $this->db->affected_rows();
   
      if ($response>0) {
         return $response;
      }else{
         return false;
      }
   }
}