<?php
//En este modelo se encuentran todas las consultas realizadas en la tabla de productosfranquicias y productosgenerales(Franquiciatario)
class ProductoPublicoA_model extends CI_Model { 
   public function __construct() {
      parent::__construct();

   }

    //Función que hace la busqueda del producto selecionado 
    public function buscarProductoAd($title){
    $this->db->join('tipoproducto','TipoProducto_IdTipoProducto=IdTipoProducto','inner');
    $this->db->join('categoria','Categoria_IdCategoria=IdCategoria','inner');
    $this->db->where('TipoProducto_IdTipoProducto','2');
    $this->db->like('NombreProducto',$title);
    $this->db->order_by('NombreProducto','ASC');
    
    return $this->db->get('productosgenerales')->result();
   }


    //Cosulta que hace el registros de productos al público en la base de datos
   public function guardar($parametro){
    $campos=array(
         'IdProductosFranquicias' => $parametro['IdProductosFranquicias'],
         'ProductosGenerales_IdProductosGenerales' => $parametro['ProductosGenerales_IdProductosGenerales'],
         'PiezasTotales' => $parametro['PiezasTotales'],
         'Franquicias_IdFranquicias' => $parametro['Franquicias_IdFranquicias'],
         'Usuarios_IdUsuarios' => $parametro['Usuarios_IdUsuarios'],
      );
      $this->db->insert('productosfranquicias',$campos);
      $res=$this->db->affected_rows();
      //Verifica que la consulta se realizo 
      if($res==1){
         //Muestra una alerta cuando no se realizo
        // echo "<script>alert('Datos guardados correctamente');</script>";
        // redirect('productos/Franquiciatario/productoPublico','refresh');
        echo "<script>alert('Datos guardados correctamente');
                 window.location.href='".base_url()."productos/Franquiciatario/productoPublico';
                 </script>";
      }else{
        //Verifica que la consulta se realizo 
        // echo "<script>alert('El producto ya fue registrado anteriormente');</script>";
        // redirect('productos/Franquiciatario/productoPublico','refresh');
        echo "<script>alert('El producto ya fue registrado anteriormente');
                 window.location.href='".base_url()."productos/Franquiciatario/productoPublico';
                 </script>";

    }
  
   }

   //Consulta que elimina los productos
   public function eliminar ($id){
      
      $this->db->where('IdProductosFranquicias', $id);
      $this->db->where('PiezasTotales=0');
      $this->db->delete('productosfranquicias');
      $res=$this->db->affected_rows();
      echo json_encode($res);
      if($res==0){
        //Muestra una alerta cuando se realizo
      // echo "<script>alert('Error, no se pudierón eliminar los datos debido a que se ecuentran existencias del producto seleccionado');</script>";
      // redirect('productos/Franquiciatario/productoPublico','refresh');
       echo "<script>alert('Error, no se pudierón eliminar los datos debido a que se encuentran existencias del producto seleccionado');
                 window.location.href='".base_url()."productos/Franquiciatario/productoPublico';
                 </script>";
      }else{
        //Muestra una alerta cuando no se realizo
     //  echo "<script>alert('Los datos se han eliminado correctamente');</script>";
     // redirect('productos/Franquiciatario/productoPublico','refresh');
      echo "<script>alert('Los datos se han eliminado correctamente');
                 window.location.href='".base_url()."productos/Franquiciatario/productoPublico';
                 </script>";
      }
   }

    //Consulta que hace la busqueda del producto seleccionado
    public function obtenerenlace ($id){
      $this->db->select('*');
      $this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales=IdProductosGenerales','inner');
      $this->db->where('IdProductosFranquicias', $id);
      $query=$this->db->get('productosfranquicias');
      if($query->num_rows()>0){
         return $query;

      }else{
         return FALSE;
      }

   }

    //Consulta que hace la actualización del producto seleccionado
    function editarenlace ($IdProductosGenerales, $data)
   {
      $this->db->where('IdProductosFranquicias', $IdProductosGenerales);
      $this->db->update('productosfranquicias', $data);
      $res=$this->db->affected_rows();
       //Verifica que la consulta se realizo
      if($res==1){
        //Muestra una alerta cuando se realizo
        // echo "<script>alert('Datos guardados correctamente');</script>";
        // redirect('productos/Franquiciatario/productoPublico','refresh');
        echo "<script>alert('Datos guardados correctamente');
                 window.location.href='".base_url()."productos/Franquiciatario/productoPublico';
                 </script>";
      }else if($res==-1){
        //Muestra una alerta cuando no se realizo
       //  echo "<script>alert('Los datos no pudierón ser guardados correctamente');</script>";
       // redirect("productos/Franquiciatario/productoPublico/editar/$IdProductosGenerales",'refresh');
       echo "<script>alert('Los datos no pudierón ser guardados correctamente');
                 window.location.href='".base_url()."productos/Franquiciatario/productoPublico/editar/$IdProductosGenerales';
                 </script>";
      }else {
        // echo "<script>alert('No se hizo nungun cambio');</script>";
        // redirect('productos/Franquiciatario/productoPublico','refresh');
        echo "<script>alert('No se hizo nungun cambio');
                 window.location.href='".base_url()."productos/Franquiciatario/productoPublico';
                 </script>";
                 
      }
   }
//Consulta que hace la busqueda de los tipos de productos 
  public function BuscarTipo(){
     $query = $this->db-> query('SELECT IdTipoProducto,NombreTipoProducto FROM tipoproducto WHERE IdTipoProducto = 2'); 
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdTipoProducto, ENT_QUOTES)] = htmlspecialchars($row->NombreTipoProducto, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }

  //Consulta que hace la busqueda de la categoría de los productos 
 //Consulta que hace la busqueda de la categoría de los productos 
  public function BuscarCategoria(){
     $query = $this->db-> query('SELECT IdCategoria,NombreCategoria FROM categoria'); 
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdCategoria, ENT_QUOTES)] = htmlspecialchars($row->NombreCategoria, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }


   /*public function BuscarCategoria1($IdFranquicias){
     $query = $this->db-> query('SELECT IdCategoria,NombreCategoria FROM categoria where '); 
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdCategoria, ENT_QUOTES)] = htmlspecialchars($row->NombreCategoria, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
      }
  */
  //Consulta que hace la busqueda de todos los productos registrados de tipo interno 
  public function BuscarProducto(){
     $query = $this->db-> query('SELECT * FROM productosgenerales WHERE TipoProducto_IdTipoProducto = 2'); 
       return $query->result();
         }
  //Consulta que hace la busqueda de la franquicia a la que pertenece el usuario logueado 
  public function BuscarFranquicia(){
     $this->db->select('IdFranquicias,NombreFranquicia');
     $this->db->from('usuarios');
     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdFranquicias, ENT_QUOTES)] = htmlspecialchars($row->NombreFranquicia, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }

 //Consulta que la busqueda de los datos del usuario logueado 
 public function BuscarUsuario(){
     $this->db->select('*');
     $this->db->from('usuarios');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdUsuarios, ENT_QUOTES)] = htmlspecialchars($row->NombreUsuario, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }

}
