<?php
class ReportesClientes_Model extends CI_Model
{ 
  public function reportesCumpleanios($inicio,$fin){
    $idFranquicia =  $this->BuscarIdFranquicia();

    $this->db->select("*");
    $this->db->where('franquicias_IdFranquicias',$idFranquicia);
    $this->db->where('MONTH(FechaNacimientoCliente) >=', $inicio[1]);
    $this->db->where('MONTH(FechaNacimientoCliente) <=', $fin[1]);
    $this->db->from('clientes');
       return $this->db->get();
  }
   public function BuscarIdFranquicia(){
     $this->db->select('*');
     $this->db->from('usuarios');
     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
              return $row->IdFranquicias; }
  } 
  
    public function todosClientes($inicio, $fin)
    {
      $idFranquicia =  $this->BuscarIdFranquicia();
      $this->db->select("*");
      $this->db->where('franquicias_IdFranquicias',$idFranquicia);
      // $this->db->where('FechaCreacion >=', $inicio.' 00:00:00');
      // $this->db->where('FechaCreacion <=', $fin.' 23:59:59');
      $this->db->from('clientes');
      $query=$this->db->get();
      $cliente=[];
      if ($query->num_rows() > 0) {         
       foreach($query->result() as $fila)
       {
         if($fila->FechaNacimientoCliente==null)
         {
           $fecha='';
         }elseif($fila->FechaNacimientoCliente=='0000-00-00'){
           $fecha='00-00-0000';
         }else{
           $fecha=date("d-m-Y", strtotime($fila->FechaNacimientoCliente));
         }
        $cliente[] = array(
                            $fila->NombreCliente, 
                            $fecha, 
                            // $fila->FechaNacimientoCliente,
                            $fila->TelefonoCliente, 
                            $fila->CelularCliente, 
                            $fila->CorreoCliente, 
                            $fila->DireccionCliente, 
                            $fila->SexoCliente, 
                            $fila->EdadCliente, 
                            $fila->MedioInformacion, 
                            $fila->RecomendadoPor, 
                            $fila->Autoriza, 
                            $fila->FechaCreacion, 
                          );
        
       }         
      } 
      echo json_encode($cliente);     
    }
    public function clientesNuevos($inicio, $fin)
    {
      $idFranquicia =  $this->BuscarIdFranquicia();
      $this->db->select("*");
      $this->db->where('franquicias_IdFranquicias',$idFranquicia);
      $this->db->where('FechaCreacion >=', $inicio.' 00:00:00');
      $this->db->where('FechaCreacion <=', $fin.' 23:59:59');
      $this->db->from('clientes');
      $query=$this->db->get();
      $cliente=[]; 
      if ($query->num_rows() > 0) {         
       foreach($query->result() as $fila)
       {
        if($fila->FechaNacimientoCliente==null)
        {
          $fecha='';
        }elseif($fila->FechaNacimientoCliente=='0000-00-00'){
          $fecha='00-00-0000';
        }else{
          $fecha=date("d-m-Y", strtotime($fila->FechaNacimientoCliente));
        }
        $cliente[] = array(
                            $fila->NombreCliente, 
                            $fecha, 
                            $fila->TelefonoCliente, 
                            $fila->CelularCliente, 
                            $fila->CorreoCliente, 
                            $fila->DireccionCliente, 
                            $fila->SexoCliente, 
                            $fila->EdadCliente, 
                            $fila->MedioInformacion, 
                            $fila->RecomendadoPor, 
                            $fila->Autoriza, 
                            $fila->FechaCreacion, 
                          );
        
       }         
      }
      echo json_encode($cliente);      
    
    }
    public function clientesProspecto($inicio, $fin)
    {
      $idFranquicia =  $this->BuscarIdFranquicia();
      $this->db->select("*");
      $this->db->where('franquicias_IdFranquicias',$idFranquicia);
      $this->db->where('FechaCreacion >=', $inicio.' 00:00:00');
      $this->db->where('FechaCreacion <=', $fin.' 23:59:59');
      $this->db->where('FechaNacimientoCliente','0000-00-00');
      $this->db->where('TelefonoCliente','0000000000');
      $this->db->where('CorreoCliente','XXX@XXXX.XXX');
      $this->db->where('DireccionCliente','XXXXXXXXXX');
      $this->db->where('EdadCliente','00');
      $this->db->where('SexoCliente','OTRO');
      $this->db->where('EstadoCivil',NULL);
      $this->db->where('Ocupacion','XXXXXXXXXX');
      $this->db->where('MedioInformacion','OTRO');
      $this->db->where('RecomendadoPor','XXXXXXXXXX');
      $this->db->where('Autoriza','No');
      $this->db->from('clientes');
      $query=$this->db->get();

      $this->db->select("*");
      $this->db->where('franquicias_IdFranquicias',$idFranquicia);
      $this->db->where('FechaCreacion >=', $inicio.' 00:00:00');
      $this->db->where('FechaCreacion <=', $fin.' 23:59:59');
      $this->db->where('FechaNacimientoCliente is NULL');
      $this->db->where('TelefonoCliente is NULL');
      $this->db->where('CorreoCliente is NULL');
      $this->db->where('DireccionCliente is NULL');
      $this->db->where('EdadCliente is NULL');
      $this->db->where('SexoCliente is NULL');
      $this->db->where('EstadoCivil',NULL);
      $this->db->where('Ocupacion  is NULL');
      $this->db->where('MedioInformacion is NULL');
      $this->db->where('RecomendadoPor is NULL');
      $this->db->where('Autoriza is NULL');
      $this->db->from('clientes');
      $query2=$this->db->get();
      $cliente=[];
      if ($query->num_rows() > 0) {         
       foreach($query->result() as $fila)
       {
        if($fila->FechaNacimientoCliente==null)
        {
          $fecha='';
        }elseif($fila->FechaNacimientoCliente=='0000-00-00'){
          $fecha='00-00-0000';
        }
        $cliente[] = array(
                            $fila->NombreCliente, 
                            $fecha, 
                            $fila->TelefonoCliente, 
                            $fila->CelularCliente, 
                            $fila->CorreoCliente, 
                            $fila->DireccionCliente, 
                            $fila->SexoCliente, 
                            $fila->EdadCliente, 
                            $fila->MedioInformacion, 
                            $fila->RecomendadoPor, 
                            $fila->Autoriza, 
                            $fila->FechaCreacion, 
                          );
        
       }  
       
      }
      if ($query2->num_rows() > 0) {         
        foreach($query2->result() as $fila)
        {
         $cliente[] = array(
                             $fila->NombreCliente, 
                             $fila->FechaNacimientoCliente, 
                             $fila->TelefonoCliente, 
                             $fila->CelularCliente, 
                             $fila->CorreoCliente, 
                             $fila->DireccionCliente, 
                             $fila->SexoCliente, 
                             $fila->EdadCliente, 
                             $fila->MedioInformacion, 
                             $fila->RecomendadoPor, 
                             $fila->Autoriza, 
                             $fila->FechaCreacion, 
                           );
         
        }  
        
       }
      echo json_encode($cliente);     
    }
    public function clientesFrecuentes($inicio, $fin)
    {
        $idFranquicia =  $this->BuscarIdFranquicia();
        $this->db->select("*", 'COUNT(*)');
        $this->db->join('ventas','IdCliente = IdClientes','inner');
        $this->db->where('clientes.franquicias_IdFranquicias',$idFranquicia);
        $this->db->where('ventas.FechaCreacion >=', $inicio.' 00:00:00');
        $this->db->where('ventas.FechaCreacion <=', $fin.' 23:59:59');
        $this->db->group_by('IdCliente');
        $this->db->having('COUNT(*) >= 3');
        $this->db->from('clientes');        
        $query=$this->db->get();
        $cliente=[];
        if ($query->num_rows() > 0) {         
        foreach($query->result() as $fila)
        {
          if($fila->FechaNacimientoCliente==null)
          {
            $fecha='';
          }elseif($fila->FechaNacimientoCliente=='0000-00-00'){
            $fecha='00-00-0000';
          }else{
            $fecha=date("d-m-Y", strtotime($fila->FechaNacimientoCliente));
          }
          $cliente[] = array(
                              $fila->NombreCliente, 
                              $fecha, 
                              $fila->TelefonoCliente, 
                              $fila->CelularCliente, 
                              $fila->CorreoCliente, 
                              $fila->DireccionCliente, 
                              $fila->SexoCliente, 
                              $fila->EdadCliente, 
                              $fila->MedioInformacion, 
                              $fila->RecomendadoPor, 
                              $fila->Autoriza, 
                              $fila->FechaCreacion, 
                            );
          
          }         
        }
        echo json_encode($cliente);
    }
    public function cumpleanios($inicio, $fin)
    {
      $idFranquicia =  $this->BuscarIdFranquicia();
      list($anio, $mes, $dia) = explode('-', $inicio);
      list($anioF, $mesF, $diaF) = explode('-', $fin);
      $this->db->select("*");
      $this->db->where('franquicias_IdFranquicias',$idFranquicia);
      // $this->db->where('MONTH(FechaNacimientoCliente) >=', $mes);
      // $this->db->where('MONTH(FechaNacimientoCliente) <=', $mesF);
      $this->db->where("DATE_FORMAT(FechaNacimientoCliente,'%m-%d') >=", $mes.'-'.$dia);
      $this->db->where("DATE_FORMAT(FechaNacimientoCliente,'%m-%d') <=", $mesF.'-'.$diaF);
      $this->db->from('clientes');
      $query=$this->db->get();
      $cliente=[];
      if ($query->num_rows() > 0) {         
      foreach($query->result() as $fila)
      {
        if($fila->FechaNacimientoCliente==null)
        {
          $fecha='';
        }elseif($fila->FechaNacimientoCliente=='0000-00-00'){
          $fecha='00-00-0000';
        }else{
          $fecha=date("d-m-Y", strtotime($fila->FechaNacimientoCliente));
        }
        $cliente[] = array(
                            $fila->NombreCliente, 
                            $fecha, 
                            $fila->TelefonoCliente, 
                            $fila->CelularCliente, 
                            $fila->CorreoCliente, 
                            $fila->DireccionCliente, 
                            $fila->SexoCliente, 
                            $fila->EdadCliente, 
                            $fila->MedioInformacion, 
                            $fila->RecomendadoPor, 
                            $fila->Autoriza, 
                            $fila->FechaCreacion, 
                          );
        
      }        
      }
      echo json_encode($cliente);
    }
  
  
}
?>