
'use strict';
window.addEventListener( 'load', function( event )
 { 
    $.fn.datepicker.dates['en'] = {
        days: ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"],
        daysShort: ["Dom", "Lun", "Mar", "Mier", "Jue", "Vier", "Sab"],
        daysMin: ["D", "L", "Ma", "Mi", "J", "V", "S"],
        months: ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"],
        monthsShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        today: "Today",
        clear: "Clear",

        weekStart: 0
    };

    $.datepicker.setDefaults($.datepicker.regional['en']);     
     var today = new Date();
    /* $(".date-picker").attr("data-date-end-date","today+2m");*/
     $(".date-picker").datepicker({
        isRTL: false,
        format: "dd-mm-yyyy",
       /* yearRange: "0000",*/
        viewMode: "months,days", 
        minViewMode: "months,days",
        autoclose: true,
    });
    $('.date-picker').datepicker('setDate', 'today');
    $(".date-cumple").datepicker({
        isRTL: false,
        format: "dd-mm-0000",
       /* yearRange: "0000",*/
        viewMode: "months,days", 
        minViewMode: "months,days",
        autoclose: true,
    });
    $('.date-cumple').datepicker('setDate', 'today');
    $('#filtrarReportes').click(function(){
        
      $.fn.dataTable.ext.errMode = 'none';
      $('#reporte-clientes').on('error.dt', function(e, settings, techNote, message) {
         console.log( 'An error has been reported by DataTables: ', message);
      });
      $('#reporte-clientes').empty();
      
      $('#reporte-clientes').unbind();
      
          var fechainicio = $('#fechainicio').val();
          var fechafin = $("#fechafin").val();
          var fechainicio2 = $('#fechainicio2').val();
          var fechafin2 = $("#fechafin2").val();
          var filtrar = $('#filtrar').val();
          var nombreReporte='';
          var tituloReporte='';
          switch(filtrar){
            case "":
                nombreReporte='ReporteClientes';
                tituloReporte='Reporte de clientes';
            break;
            case "1":
                nombreReporte='ReporteClientesNuevos';
                tituloReporte='Reporte de clientes nuevos';
            break;
            case "2":
                nombreReporte='ReporteClientesProspecto';
                tituloReporte='Reporte de clientes prospecto';
            break;
            case "3":
                nombreReporte='ReporteClientesFrecuentes';
                tituloReporte='Reporte de clientes frecuentes';
            break;
            case "4":
                    nombreReporte='ReporteCumpleaños';
                    tituloReporte='Reporte de cumpleaños';
            break;

          }
          console.log(fechainicio);
          console.log(fechafin);
          console.log(filtrar);

      
      
          if( fechainicio != '' && fechafin != '' || fechainicio2 != '' && fechafin2 != '')
          {
            $('#modal-loader').modal();
                   
                  $.ajax({
                  url:base_url+"reportes/Franquiciatario/ReportesClientes/buscarReportes",
                  type:'POST',
                  dataType: 'json',
                  data:{finicio : fechainicio, ffin : fechafin, finicio2 : fechainicio2, ffin2 : fechafin2, filtrar:filtrar},
                  success:function(response){
                    $('#modal-loader').modal('hide');
                       console.log(response);
                      console.log("exito");
                      toastr.success('Se realizó tu busqueda se encontraron '+ response.length +' resultados').css("width","100%");
                      var columns = [
                          { "title":"Nombre" },
                          { "title":"Fecha nacimiento" },
                          { "title":"Teléfono" },
                          { "title":"Celular" },
                          { "title":"Correo" },
                          { "title":"Dirección" },
                          { "title":"Sexo" },
                          { "title":"Edad" },
                          { "title":"Medio de información" },
                          { "title":"Recomendado por" },
                          { "title":"Autorización uso de datos" },
                          { "title":"Fecha de registro" },
                      ];   
      
                       var hide = [
                              { targets: [0,1,2,3,4,5,6,7,8,9,10,11], visible: true},
                             /* { targets: [8], visible: false }*/
                          ];
                        
      
                    //   $("#reporte-clientes").append('<tfoot class="dataFooter"><tr><th></th><th></th><th></th><th></th><th></th><th></th><th></th></tr></tfoot>'); 
                      $('#reporte-clientes').DataTable( {
                          dom: 'T<"clear">Bfrtip',
                          responsive: true,
                          columnDefs: hide,
                          data: response,
                          columns: columns,
                          ServerSide: true,
                           destroy: true,
                           footer: false,
                           processing: true,
                           buttons: [
                          {
                              extend: 'print',
                              text:"IMPRIMIR",
                              footer: true,
                              orientation: 'landscape',
                              pageSize: 'A4',
                              /*messageTop: 'Reporte de Ventas',*/
                              title: '',
                              exportOptions: {
      
                               body : {margin: [ 0, 0, 0, 0 ], pageMargins: [ 0, 0, 0, 0 ]},
                                columns: [0,1,2,3,4,5,6,7,8,9,10,11]//son las columnas q quiero q se vean al exportarse          
      
                            },
                              customize: function ( win ) {
      
                                  $(win.document.body)
                                  .css( 'font-size', '8pt' )
                                  .prepend(
                                      '<div style="width: 100%; font-size:2em; text-align: center;">Reporte de clientes</div>'
                                      );
      
                                  $(win.document.body).find( 'table' )
                                  .addClass( 'compact' )
                                  .css( 'font-size', 'inherit' );
                                  $(win.document.body).find( 'table' )
                                  .addClass( 'mayus' )
                                  .css( 'text-transform', 'uppercase' );
                                  $(win.document.body).find( 'table' )
                                  .css( 'margin-left', '3em');
                                  $(win.document.body).find( 'table' )
                                  .css('margin-right','3em' );
                              },
                              
                          },
                          {
                              
                              extend: 'pdf',
                              text:"PDF",
                              footer: true,
                              filename: nombreReporte,
                              /*messageTop: 'Reporte de Ventas',*/
                              orientation: 'landscape',
                              pageSize: 'A4',
                              title: tituloReporte,
                              key: { 
                                  key: 'e',
                                  altKey: false
                              },
        
                              exportOptions: {
      
                                  body : {margin: [ 0, 0, 0, 0 ], pageMargins: [ 0, 0, 0, 0 ]},
                                  footer: true,
                                  columns:[0,1,2,3,4,5,6,7,8,9,10,11],//son las columnas q quiero q se vean al exportarse 
                                  
      
                              },
                              
                              // body : {margin: [ 0, 0, 0, 0 ], pageMargins: [ 0, 0, 0, 0 ]},
                              customize: function ( doc ) {
                                doc.content[1].table.widths = ['8.7%','8.3%','8.3%','8.3%','8.3%','8.3%','8.3%','8.3%','8.3%','8.3%','8.3%','8.3%'];
                                doc.defaultStyle.alignment = 'center';
                                
                              },
                          },
                          {
                              extend: 'excel',
                              text:"EXCEL",
                              footer: true,
                              filename: nombreReporte,
                              title: tituloReporte,
                              exportOptions: {
                                modifier: {
                                    alignment: 'center',
                                    page: 'all',                             
                                }
                                , body : {margin: [ 0, 0, 0, 0 ], pageMargins: [ 0, 0, 0, 0 ]},
                                footer: true,
                                columns: [0,1,2,3,4,5,6,7,8,9,10,11]//son las columnas q quiero q se vean al exportarse          
      
                            },
                              
                              
                          }
                          // 'copy', 'csv', 'excel',
                          ],
      
                          language: {
                            "lengthMenu": "Mostrar _MENU_ registros por pagina",
                            "zeroRecords": "No se encontraron resultados en su busqueda",
                            "searchPlaceholder": "Buscar registros",
                            "info": "Mostrando registros de _START_ al _END_ de un total de  _TOTAL_ registros",
                            "infoEmpty": "No existen registros",
                            "infoFiltered": "(filtrado de un total de _MAX_ registros)",
                            "search": "Buscar:",
                            "paginate": {
                                "first": "Primero",
                                "last": "Último",
                                "next": "Siguiente",
                                "previous": "Anterior"
                            },
                        },
                           
                      });
                      $('#reporte-clientes').wrap("<div id='scrooll_div' class='scrollbar-tabla' style='width: 100%;'></div>");
                      $('#scrooll_div').doubleScroll({
                            resetOnWindowResize: true
                          });
                      return false;
      
                  },//end success ajax response
                  error:function(xhr, textStatus, errorThrown, error){
                    console.log(xhr.responseText);
                      console.log("error");
                  },
      
                  });//end ajax
          return false;
      
      }//end fechainicio y fechafin vacia
      else{
           toastr.error("Hace falta una Fecha");
          console.log("error");
          return false;
      }
      });//end click
    //   $('#filtrarReportes').trigger( "click" );
    var filtrar = document.getElementById("filtrar");
    filtrar.addEventListener("change", function() {
        var valor= filtrar.value;
        
            if(valor == "")
            {
                document.getElementById('div-desde').classList.add('invisible');
                document.getElementById('div-hasta').classList.add('invisible');
             
            }else if(valor=="4"){
                document.getElementById('div-desde').classList.remove('invisible');
                document.getElementById('div-hasta').classList.remove('invisible');
                document.getElementById('fechainicio').classList.add('invisible');                
                document.getElementById('fechafin').classList.add('invisible');
                document.getElementById('fechainicio2').classList.remove('invisible');                
                document.getElementById('fechafin2').classList.remove('invisible');
            }else{
                document.getElementById('div-desde').classList.remove('invisible');
                document.getElementById('div-hasta').classList.remove('invisible');
                document.getElementById('fechainicio').classList.remove('invisible');                
                document.getElementById('fechafin').classList.remove('invisible');
                document.getElementById('fechainicio2').classList.add('invisible');                
                document.getElementById('fechafin2').classList.add('invisible');
            }
        
    });

    (function(){
            function removeAccents ( data ) {
                if ( data.normalize ) {
                    /* Use la API I18n si está disponible para dividir caracteres y acentos, luego elimine
                       los acentos al por mayor. Tenga en cuenta que utilizamos los datos originales, así como
                       lo nuevo para permitir la búsqueda de cualquiera de los formularios.*/
                    return data +' '+ data
                        .normalize('NFD')
                        .replace(/[\u0300-\u036f]/g, '');
                }
             
                return data;
            }
             
            var searchType = jQuery.fn.DataTable.ext.type.search; 
            searchType.string = function ( data ) {
                return ! data ?
                    '' :
                    typeof data === 'string' ?
                        removeAccents( data ) :
                        data;
            };
             
            searchType.html = function ( data ) {
                return ! data ?
                    '' :
                    typeof data === 'string' ?
                        removeAccents( data.replace( /<.*?>/g, '' ) ) :
                        data;
            };
        }());
 }); //Fin window.addEventListener
//  ---------------Funciones----------------
