$(document).ready(function() { 
    $.ajax({
        type: "POST",
        url:base_url+"myagenda/franquiciatario/ListacitasF/AlerTomadoS/",
        dataType: "json",
        async: false,
        success: function(data) {
            if (data.timeAstatusC != null) {
                countdown2(data.timeAstatusC, 'clock');
            }else{
                document.getElementById('clock').style.display = "block";
            }
        } 
    });        
});

const getRemainTime2 = deadline=>{
	let now2 = Date.now();
	remainTime = (deadline- now2 + 1000)/1000;
	remainSeconds = ('0' + Math.floor(remainTime % 60)).slice(-2);
	remainMinutes = ('0' + Math.floor(remainTime / 60 % 60)).slice(-2);
	remainHours = ('0' + Math.floor(remainTime / 3600 % 24)).slice(-2);
	remainDays = Math.floor(remainTime / (3600 * 24));

	return {
		remainTime,
		remainSeconds,
		remainMinutes,
		remainHours,
		remainDays
	}
};

const countdown2 = (deadline,elem2) =>{
const el2 = document.getElementById(elem2);

	const timerUpdate2 = setInterval(() => {
		let time2 = getRemainTime2(deadline);
		el2.innerHTML=`${time2.remainDays}d:${time2.remainHours}h:${time2.remainMinutes}m:${time2.remainSeconds}s`;
		if (time2.remainTime <= 1) {
			clearInterval(timerUpdate2);
			timeAlertStatusC();
			var dateTime = document.getElementById('fechaFooter').value;

			console.log(dateTime); 

			$.ajax({
			  type: "POST",
			  url:base_url+"myagenda/franquiciatario/ListacitasF/citasActuales/",
			  data:{'dateTime':dateTime},
			  dataType: "json",
			  async: false,
			  success: function(data) {
			    console.log(data);   
			    if (data) {
			    	$.citasActuales();
					$('#statusCitas').modal('show');
			    }else{
			    	timeAlertStatusC();
			    }        
			  },
			  error: function(xhr, textStatus, errorThrown, error) {
			      console.log('Error');//xhr.responseText);
			  }
			});
		}
	},1000)
}; 

$.extend({
  citasActuales: function() {
    var dateTime = document.getElementById('fechaFooter').value;
  	$.ajax({
        url:base_url+"myagenda/franquiciatario/ListacitasF/tablaCitasActuales/", 
        type:'POST',
        dataType: 'json',
        data:{'dateTime' : dateTime},
        success:function(response){
            console.log(response);

            var columns = [
              {"title":"No. Cita"},
              {"title":"Fecha cita" },
              {"title":"Cliente" },
              {"title":"Estado actual"},
              {"title":"Estado" },
              {"title":"Observaciones" }
            ];   

            var hide = [
                  { targets: [0, 1,2,3], visible: true},
            ];

           document.getElementById("tbl_StatusCita").deleteTFoot();
            $("#tbl_StatusCita").append('<tfoot class="dataFooter"><tr><th></th><th></th><th></th><th></th><th></th><th></th></tr></tfoot>'); 

            $('#tbl_StatusCita').DataTable({
              responsive: true,
              columnDefs: hide,
              data: response,
              columns: columns,
              ServerSide: true,
                destroy: true,
                footer: true,
                processing: true,
                searching: false,
                pagination:false,
              language: {
                  "lengthMenu": "Mostrar _MENU_ registros por página",
                  "zeroRecords": "No se encontraron resultados en su busqueda",
                  "info": " _END_ servicios de  _TOTAL_ \n",
                  "infoEmpty": "No existen registros",
                  "infoFiltered": "(filtrado de un total de _MAX_ registros)",
              },

            });

            $('.selectpicker').selectpicker('refresh');
            $('#tbl_StatusCita').wrap("<div id='scrollbar-tabla' class='scrollbar-tabla'></div>");
            $('#scrollbar-tabla').doubleScroll({
                resetOnWindowResize: true
            });


      //Búsqueda con y sin acento... 
        (function(){
            function removeAccents ( data ) {
                if ( data.normalize ) {
                    /* Use la API I18n si está disponible para dividir caracteres y acentos, luego elimine
                       los acentos al por mayor. Tenga en cuenta que utilizamos los datos originales, así como
                       lo nuevo para permitir la búsqueda de cualquiera de los formularios.*/
                    return data +' '+ data
                        .normalize('NFD')
                        .replace(/[\u0300-\u036f]/g, '');
                }
             
                return data;
            }
             
            var searchType = jQuery.fn.DataTable.ext.type.search; 
            searchType.string = function ( data ) {
                return ! data ?
                    '' :
                    typeof data === 'string' ?
                        removeAccents( data ) :
                        data;
            };
             
            searchType.html = function ( data ) {
                return ! data ?
                    '' :
                    typeof data === 'string' ?
                        removeAccents( data.replace( /<.*?>/g, '' ) ) :
                        data;
            };
        }());

        var y = document.getElementById("tbl_StatusCita_wrapper");
        var buttonsDat = document.getElementById("tbl_StatusCita_length");
        buttonsDat.style.display='none';

  },//end success ajax response
    error:function(){
        console.log("error");
    },

  });
}
});

function timeAlertStatusC(){
    var cambio = Date.now()+900000;//100000;
    console.log(cambio);
    $.ajax({
        type: "POST",
        url:base_url+"myagenda/franquiciatario/ListacitasF/timeStatusC",
        dataType: "json",
        data:{time:cambio},
        async: false,
        success: function(data) {
            console.log(data);
            if (data != false) {
                countdown2(data, 'clock');
            }else{
                document.getElementById('clock').style.display = "block";
            }
        },
        error: function(xhr, textStatus, errorThrown, error) {
            console.log(xhr.responseText);
        }
    });
}

function tblStatusC(){
    var parametros=[];
    var parame=[];
    $("#tbl_StatusCita tbody tr").each(function(i,e){    
        var tr = [];
        $(this).find("td").each(function(index, element){
            if(index==0){
                var td={};
                td["idAgenda"]=$(this).html();
                tr.push(td);
            }else if(index == 4) {
                // ignoramos el primer indice que dice Option #
                var td1 = {};
                td1["estado"] = $(this).find("select").val();
                tr.push(td1);
            }else if(index == 5){
                var td2 = {};
                td2["observaciones"] = $(this).find("textarea").val();
                tr.push(td2);
            } 
        });
        parametros.push(tr);    
    });
    
    $.ajax({
        type: "POST",
        url:base_url+"myagenda/franquiciatario/ListacitasF/cambiarStatusC",
        dataType: "json",
        data:{'data': JSON.stringify(parametros)},
        //async: false,
        success: function(data) {
            if (data!=false) {
                $('#statusCitas').modal('hide');
                swal({
                    title: 'Citas actualizadas correctamente',
                    icon: 'success',
                    showConfirmButton: false,
                    timer: 1500
                })  
            }
        },
        error: function(xhr, textStatus, errorThrown, error) {
            console.log(xhr.responseText);
        }
    });
}